/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.account;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.account.Account;
import software.tnb.common.account.WithId;
import software.tnb.common.account.loader.CredentialsLoader;
import software.tnb.common.account.loader.VaultCredentialsLoader;
import software.tnb.common.account.loader.YamlCredentialsLoader;
import software.tnb.common.config.TestConfiguration;

public final class AccountFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AccountFactory.class);
    private static CredentialsLoader loader;

    private AccountFactory() {
    }

    public static <T extends Account> T create(Class<T> accountClass) {
        Account instance = (Account)AccountFactory.createInstance(accountClass);
        if (instance instanceof WithId) {
            LOG.debug("Loading {} account", (Object)accountClass.getSimpleName());
            if (loader == null) {
                try {
                    AccountFactory.createLoader();
                }
                catch (Exception e) {
                    Assertions.fail((String)"Could not load credentials", (Throwable)e);
                }
            }
            return loader.get(AccountFactory.getCredentialsIds(instance), accountClass);
        }
        LOG.debug("Initialization of {}. No credentials loading needed.", (Object)accountClass.getSimpleName());
        return (T)instance;
    }

    private static void createLoader() throws Exception {
        if (TestConfiguration.useVault()) {
            if (TestConfiguration.vaultToken() != null) {
                LOG.info("Logging into vault using github token");
                loader = new VaultCredentialsLoader(TestConfiguration.vaultAddress(), TestConfiguration.vaultPathPattern(), TestConfiguration.vaultToken());
            } else {
                LOG.info("Logging into vault using approle");
                loader = new VaultCredentialsLoader(TestConfiguration.vaultAddress(), TestConfiguration.vaultPathPattern(), TestConfiguration.vaultRoleId(), TestConfiguration.vaultSecretId());
            }
        } else if (TestConfiguration.credentials() != null) {
            LOG.info("loading credentials from property");
            loader = new YamlCredentialsLoader(TestConfiguration.credentials());
        } else {
            LOG.info("Loading credentials from file");
            loader = new YamlCredentialsLoader(new File(TestConfiguration.credentialsFile()));
        }
    }

    private static <T extends Account> List<String> getCredentialsIds(T instance) {
        Function<WithId, String> withId = WithId::getId;
        ArrayList<String> ids = new ArrayList<String>();
        for (Class<?> current = instance.getClass(); current != null; current = current.getSuperclass()) {
            if (!WithId.class.isAssignableFrom(current)) continue;
            ids.add(withId.apply((WithId)AccountFactory.createInstance(current)));
        }
        Collections.reverse(ids);
        return ids;
    }

    private static <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create instance of " + clazz.getName() + " class: ", e);
        }
    }
}

