/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.account;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import software.tnb.common.utils.StringUtils;

public interface Account {
    default public Properties toProperties() {
        Properties properties = new Properties();
        for (Field field : this.getAllFields(new ArrayList<Field>(), this.getClass())) {
            try {
                field.setAccessible(true);
                properties.put(StringUtils.replaceUnderscoreWithCamelCase((String)field.getName()), field.get(this));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to get field " + field.getName() + " value: ", e);
            }
        }
        return properties;
    }

    private List<Field> getAllFields(List<Field> fields, Class<?> clazz) {
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            this.getAllFields(fields, clazz.getSuperclass());
        }
        return fields;
    }
}

