/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.cassandra.resource.local;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.google.auto.service.AutoService;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.db.cassandra.resource.local.CassandraContainer;
import software.tnb.db.cassandra.service.Cassandra;

@AutoService(value={Cassandra.class})
public class LocalCassandra
extends Cassandra
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCassandra.class);
    private CassandraContainer container;
    private CqlSession session;

    public void deploy() {
        LOG.info("Starting cassandra container");
        this.container = new CassandraContainer(this.image(), 9042, this.containerEnvironment());
        this.container.start();
    }

    public void undeploy() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    public void openResources() {
        DriverConfigLoader loader = ((ProgrammaticDriverConfigLoaderBuilder)DriverConfigLoader.programmaticBuilder().withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ofSeconds(30L))).build();
        this.session = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().withConfigLoader(loader)).addContactPoint(new InetSocketAddress(this.host(), this.port()))).withAuthCredentials(this.account().username(), this.account().password())).withLocalDatacenter(this.account().datacenter())).build();
    }

    public void closeResources() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @Override
    public String host() {
        return this.container.getContainerIpAddress();
    }

    @Override
    public int port() {
        return this.container.getMappedPort(9042);
    }

    @Override
    protected CqlSession session() {
        return this.session;
    }
}

