/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.cassandra.resource.local;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;

public class CassandraContainer
extends GenericContainer<CassandraContainer> {
    private final int port;

    public CassandraContainer(String image, int port, Map<String, String> env) {
        super(image);
        this.port = port;
        this.withExposedPorts(new Integer[]{port});
        HashMap<String, String> localEnv = new HashMap<String, String>(env);
        localEnv.put("MAX_HEAP_SIZE", "256M");
        localEnv.put("HEAP_NEWSIZE", "128M");
        this.withEnv(localEnv);
        this.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withMemory(Long.valueOf(0x40000000L)));
        this.waitingFor(Wait.forLogMessage((String)".*Startup complete.*", (int)1).withStartupTimeout(Duration.ofMinutes(5L)));
    }

    public int getPort() {
        return this.getMappedPort(this.port);
    }
}

