/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.cassandra.validation;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import java.util.ArrayList;
import java.util.Collection;
import software.tnb.common.validation.Validation;

public class CassandraValidation
implements Validation {
    private final CqlSession session;

    public CassandraValidation(CqlSession session) {
        this.session = session;
    }

    public void createKeyspace(String keyspace) {
        CreateKeyspace createKeyspace = (CreateKeyspace)SchemaBuilder.createKeyspace((String)keyspace).ifNotExists().withSimpleStrategy(1);
        this.session.execute((Statement)createKeyspace.build());
        this.session.execute("USE " + CqlIdentifier.fromCql((String)keyspace));
    }

    public ResultSet execute(String query) {
        return this.session.execute(query);
    }

    public Collection<Object> select(String keyspace, String table) {
        this.session.execute("USE " + keyspace);
        ArrayList<Object> result = new ArrayList<Object>();
        this.execute("select * from " + table).forEach(result::add);
        return result;
    }
}

