/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.cassandra.resource.openshift;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.google.auto.service.AutoService;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.deployment.WithExternalHostname;
import software.tnb.common.deployment.WithInClusterHostname;
import software.tnb.common.deployment.WithName;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.IOUtils;
import software.tnb.common.utils.NetworkUtils;
import software.tnb.common.utils.WaitUtils;
import software.tnb.db.cassandra.account.CassandraAccount;
import software.tnb.db.cassandra.service.Cassandra;

@AutoService(value={Cassandra.class})
public class OpenshiftCassandra
extends Cassandra
implements OpenshiftDeployable,
WithName,
WithInClusterHostname,
WithExternalHostname {
    private CqlSession session;
    private LocalPortForward portForward;
    private int localPort;

    public void create() {
        OpenshiftClient.get().apps().deployments().createOrReplace((Object[])new Deployment[]{((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)((ProbeFluent.TcpSocketNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().editOrNewSelector().addToMatchLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endSelector()).withReplicas(Integer.valueOf(1))).editOrNewTemplate().editOrNewMetadata().addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).withNewSpec().addNewContainer().withName(this.name())).withImage(this.image())).addAllToEnv((Collection)this.containerEnvironment().entrySet().stream().map(e -> new EnvVar((String)e.getKey(), (String)e.getValue(), null)).collect(Collectors.toList()))).addNewPort().withContainerPort(Integer.valueOf(this.port()))).withName(this.name())).endPort()).withImagePullPolicy("IfNotPresent")).withNewReadinessProbe().withNewTcpSocket().withNewPort(this.name())).endTcpSocket()).withInitialDelaySeconds(Integer.valueOf(30))).withTimeoutSeconds(Integer.valueOf(5))).withFailureThreshold(Integer.valueOf(6))).endReadinessProbe()).endContainer()).endSpec()).endTemplate()).endSpec()).build()});
        OpenshiftClient.get().services().createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).withNewSpec().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).addNewPort().withName(this.name())).withPort(Integer.valueOf(this.port()))).withTargetPort(new IntOrString(Integer.valueOf(this.port())))).endPort()).endSpec()).build()});
    }

    protected CqlSession client() {
        return this.session;
    }

    @Override
    public int port() {
        return 9042;
    }

    @Override
    public String host() {
        return this.name();
    }

    public void undeploy() {
        ((ServiceResource)OpenshiftClient.get().services().withName(this.name())).delete();
        ((RollableScalableResource)OpenshiftClient.get().apps().deployments().withName(this.name())).delete();
        WaitUtils.waitFor(() -> this.servicePod() == null, (String)"Waiting until the pod is removed");
    }

    public void openResources() {
        this.localPort = NetworkUtils.getFreePort();
        this.portForward = (LocalPortForward)((ServiceResource)OpenshiftClient.get().services().withName(this.name())).portForward(this.port(), this.localPort);
        DriverConfigLoader loader = ((ProgrammaticDriverConfigLoaderBuilder)DriverConfigLoader.programmaticBuilder().withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ofSeconds(30L))).build();
        this.session = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().withConfigLoader(loader)).addContactPoint(new InetSocketAddress(this.externalHostname(), this.localPort))).withAuthCredentials(((CassandraAccount)this.account()).username(), ((CassandraAccount)this.account()).password())).withLocalDatacenter(((CassandraAccount)this.account()).datacenter())).build();
    }

    public void closeResources() {
        this.validation = null;
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        IOUtils.closeQuietly((Closeable)this.portForward);
        NetworkUtils.releasePort((int)this.localPort);
    }

    public boolean isReady() {
        PodResource pod = this.servicePod();
        if (pod != null && pod.isReady()) {
            return OpenshiftClient.get().getLogs((Pod)pod.get()).contains("Startup complete");
        }
        return false;
    }

    public boolean isDeployed() {
        return ((DeploymentList)((FilterWatchListDeletable)OpenshiftClient.get().apps().deployments().withLabel(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).list()).getItems().size() > 0;
    }

    public Predicate<Pod> podSelector() {
        return super.podSelector();
    }

    public String name() {
        return "cassandra";
    }

    public String externalHostname() {
        return "localhost";
    }
}

