/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.cassandra.service;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.Map;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.deployment.WithDockerImage;
import software.tnb.common.service.Service;
import software.tnb.db.cassandra.account.CassandraAccount;
import software.tnb.db.cassandra.validation.CassandraValidation;

public abstract class Cassandra
implements Service,
WithDockerImage {
    public static final int CASSANDRA_PORT = 9042;
    private CassandraValidation validation;
    private CassandraAccount account;

    public String defaultImage() {
        return "quay.io/fuse_qe/cassandra:4.0.7";
    }

    public CassandraValidation validation() {
        if (this.validation == null) {
            this.validation = new CassandraValidation(this.session());
        }
        return this.validation;
    }

    protected abstract CqlSession session();

    public abstract int port();

    public abstract String host();

    public String cassandraUrl(String keyspace) {
        return String.format("cql:%s:%s/%s?username=%s&password=%s", this.host(), this.port(), keyspace, this.account().username(), this.account().password());
    }

    public Map<String, String> containerEnvironment() {
        return Map.of("CASSANDRA_USER", this.account().username(), "CASSANDRA_PASSWORD", this.account().password(), "CASSANDRA_PASSWORD_SEEDER", "yes");
    }

    public CassandraAccount account() {
        if (this.account == null) {
            this.account = (CassandraAccount)AccountFactory.create(CassandraAccount.class);
        }
        return this.account;
    }
}

