/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.azure.storage.queue.validation;

import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.models.QueueMessageItem;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.validation.Validation;

public class StorageQueueValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(StorageQueueValidation.class);
    private final QueueServiceClient client;

    public StorageQueueValidation(QueueServiceClient client) {
        this.client = client;
    }

    public void createQueue(String name) {
        LOG.debug("Creating queue {}", (Object)name);
        this.client.createQueue(name);
    }

    public void deleteQueue(String name) {
        LOG.debug("Deleting queue {}", (Object)name);
        this.client.deleteQueue(name);
    }

    public void sendMessage(String queue, String message) {
        LOG.debug("Sending message {} to queue {}", (Object)message, (Object)queue);
        this.client.getQueueClient(queue).sendMessage(message);
    }

    public QueueMessageItem getMessage(String queue) {
        LOG.debug("Getting single message from queue {}", (Object)queue);
        return this.client.getQueueClient(queue).receiveMessage();
    }

    public List<QueueMessageItem> getMessages(String queue, int count) {
        LOG.debug("Getting {} messages from queue {}", (Object)count, (Object)queue);
        ArrayList<QueueMessageItem> messages = new ArrayList<QueueMessageItem>();
        this.client.getQueueClient(queue).receiveMessages(Integer.valueOf(count)).forEach(messages::add);
        return messages;
    }

    public int getQueueSize(String queue) {
        return this.client.getQueueClient(queue).getProperties().getApproximateMessagesCount();
    }
}

