/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.azure.storage.queue.service;

import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.QueueServiceClientBuilder;
import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.azure.common.account.AzureAccount;
import software.tnb.azure.storage.queue.validation.StorageQueueValidation;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.service.Service;

@AutoService(value={StorageQueue.class})
public class StorageQueue
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(StorageQueue.class);
    private AzureAccount account;
    private StorageQueueValidation validation;

    public AzureAccount account() {
        if (this.account == null) {
            this.account = (AzureAccount)AccountFactory.create(AzureAccount.class);
        }
        return this.account;
    }

    protected QueueServiceClient client() {
        LOG.debug("Creating new Storage Queue client");
        return new QueueServiceClientBuilder().endpoint(String.format("https://%s.queue.core.windows.net/%s", this.account().accountName(), this.account().accessKey())).credential(new StorageSharedKeyCredential(this.account().accountName(), this.account().accessKey())).buildClient();
    }

    public StorageQueueValidation validation() {
        return this.validation;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        LOG.debug("Creating new Storage Queue validation");
        this.validation = new StorageQueueValidation(this.client());
    }
}

