/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.azure.service.bus.validation;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.messaging.servicebus.ServiceBusSenderClient;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClient;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.tnb.azure.service.bus.account.ServiceBusAccount;
import software.tnb.azure.service.bus.service.ErrorProcessor;
import software.tnb.azure.service.bus.service.MessageProcessor;
import software.tnb.common.utils.WaitUtils;
import software.tnb.common.validation.Validation;

public class ServiceBusValidation
implements Validation {
    private final ServiceBusAccount serviceBusAccount;
    private final ServiceBusAdministrationClient adminClient;

    public ServiceBusValidation(ServiceBusAccount serviceBusAccount, ServiceBusAdministrationClient adminClient) {
        this.serviceBusAccount = serviceBusAccount;
        this.adminClient = adminClient;
    }

    public ServiceBusAccount getAzureServiceBusAccount() {
        return this.serviceBusAccount;
    }

    public void createQueue(String queue) {
        this.adminClient.createQueue(queue);
        WaitUtils.waitFor(() -> this.adminClient.getQueueExists(queue), (int)10, (long)1000L, (String)("Waiting until the queue " + queue + " is created"));
    }

    public void deleteQueue(String queue) {
        this.adminClient.deleteQueue(queue);
        WaitUtils.waitFor(() -> !this.adminClient.getQueueExists(queue), (int)10, (long)1000L, (String)("Waiting until the queue " + queue + " is deleted"));
    }

    public void sendMessage(String queue, String message) {
        ServiceBusSenderClient client = new ServiceBusClientBuilder().connectionString(this.serviceBusAccount.connectionString()).sender().queueName(queue).buildClient();
        client.sendMessage(new ServiceBusMessage(message));
    }

    public List<String> receiveMessages(String queue) {
        MessageProcessor messageProcessor = new MessageProcessor();
        ErrorProcessor errorProcessor = new ErrorProcessor();
        try (ServiceBusProcessorClient client = new ServiceBusClientBuilder().connectionString(this.serviceBusAccount.connectionString()).processor().queueName(queue).processMessage((Consumer)messageProcessor).processError((Consumer)errorProcessor).buildProcessorClient();){
            client.start();
            WaitUtils.waitFor(() -> !errorProcessor.getErrors().isEmpty() || !messageProcessor.getMessages().isEmpty(), (int)10, (long)1000L, (String)"Waiting for messages");
        }
        return Stream.concat(errorProcessor.getErrors().stream(), messageProcessor.getMessages().stream().map(serviceBusReceivedMessage -> serviceBusReceivedMessage.getBody().toString())).collect(Collectors.toList());
    }
}

