/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.azure.service.bus.validation;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.messaging.servicebus.ServiceBusSenderClient;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClient;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.tnb.azure.common.account.AzureServiceBusAccount;
import software.tnb.azure.service.bus.service.ErrorProcessor;
import software.tnb.azure.service.bus.service.MessageProcessor;
import software.tnb.common.utils.WaitUtils;

public class ServiceBusValidation {
    private final AzureServiceBusAccount azureServiceBusAccount;
    private final ServiceBusAdministrationClient adminClient;

    public ServiceBusValidation(AzureServiceBusAccount azureServiceBusAccount, ServiceBusAdministrationClient adminClient) {
        this.azureServiceBusAccount = azureServiceBusAccount;
        this.adminClient = adminClient;
    }

    public AzureServiceBusAccount getAzureServiceBusAccount() {
        return this.azureServiceBusAccount;
    }

    public void createQueue(String queue) {
        this.adminClient.createQueue(queue);
        WaitUtils.waitFor(() -> this.adminClient.getQueueExists(queue), (int)10, (long)1000L, (String)("Waiting until the queue " + queue + " is created"));
    }

    public void deleteQueue(String queue) {
        this.adminClient.deleteQueue(queue);
        WaitUtils.waitFor(() -> !this.adminClient.getQueueExists(queue), (int)10, (long)1000L, (String)("Waiting until the queue " + queue + " is deleted"));
    }

    public void sendMessage(String queue, String message) {
        ServiceBusSenderClient client = new ServiceBusClientBuilder().connectionString(this.azureServiceBusAccount.connectionString()).sender().queueName(queue).buildClient();
        client.sendMessage(new ServiceBusMessage(message));
    }

    public List<String> receiveMessages(String queue) {
        MessageProcessor messageProcessor = new MessageProcessor();
        ErrorProcessor errorProcessor = new ErrorProcessor();
        try (ServiceBusProcessorClient client = new ServiceBusClientBuilder().connectionString(this.azureServiceBusAccount.connectionString()).processor().queueName(queue).processMessage((Consumer)messageProcessor).processError((Consumer)errorProcessor).buildProcessorClient();){
            client.start();
            WaitUtils.waitFor(() -> !errorProcessor.getErrors().isEmpty() || !messageProcessor.getMessages().isEmpty(), (int)10, (long)1000L, (String)"Waiting for messages");
        }
        return Stream.concat(errorProcessor.getErrors().stream(), messageProcessor.getMessages().stream().map(serviceBusReceivedMessage -> serviceBusReceivedMessage.getBody().toString())).collect(Collectors.toList());
    }
}

