/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.azure.service.bus.service;

import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClient;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClientBuilder;
import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.tnb.azure.common.account.AzureServiceBusAccount;
import software.tnb.azure.service.bus.validation.ServiceBusValidation;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.service.Service;

@AutoService(value={ServiceBus.class})
public class ServiceBus
implements Service {
    private ServiceBusValidation validation;

    private static AzureServiceBusAccount azureServiceBusAccount() {
        return (AzureServiceBusAccount)AccountFactory.create(AzureServiceBusAccount.class);
    }

    private static ServiceBusAdministrationClient getAdminClient() {
        return new ServiceBusAdministrationClientBuilder().connectionString(ServiceBus.azureServiceBusAccount().connectionString()).buildClient();
    }

    public ServiceBusValidation validation() {
        return this.validation;
    }

    public void afterAll(ExtensionContext extensionContext) {
    }

    public void beforeAll(ExtensionContext extensionContext) {
        this.validation = new ServiceBusValidation(ServiceBus.azureServiceBusAccount(), ServiceBus.getAdminClient());
    }
}

