/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.sqs.validation;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.QueueDoesNotExistException;
import software.tnb.aws.sqs.account.SQSAccount;
import software.tnb.common.utils.WaitUtils;
import software.tnb.common.validation.Validation;

public class SQSValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(SQSValidation.class);
    private final SqsClient client;
    private final SQSAccount account;

    public SQSValidation(SqsClient client, SQSAccount account) {
        this.client = client;
        this.account = account;
    }

    public void createQueue(String name) {
        this.createQueueWithAttributes(name, null);
    }

    public void createContentBasedDeduplicationFifoQueue(String name) {
        if (!name.endsWith(".fifo")) {
            throw new IllegalArgumentException("Fifo queue name must end with .fifo");
        }
        this.createQueueWithAttributes(name, Map.of(QueueAttributeName.FIFO_QUEUE, "true", QueueAttributeName.CONTENT_BASED_DEDUPLICATION, "true"));
    }

    public void createQueueWithAttributes(String name, Map<QueueAttributeName, String> attributes) {
        LOG.debug("Creating SQS queue {}", (Object)name);
        this.client.createQueue(b -> b.queueName(name).attributes(attributes));
        WaitUtils.waitFor(() -> this.queueExists(name), (String)("Waiting until the queue " + name + " is created"));
    }

    public void setPermissiveAccessPolicy(String queue) {
        HashMap<QueueAttributeName, CallSite> attributes = new HashMap<QueueAttributeName, CallSite>();
        attributes.put(QueueAttributeName.POLICY, (CallSite)((Object)("{\n\"Version\": \"2008-10-17\",\n\"Id\": \"__default_policy_ID\",\n\"Statement\": [\n  {\n    \"Sid\": \"__owner_statement\",\n    \"Effect\": \"Allow\",\n    \"Principal\": {\n      \"AWS\": \"*\"\n    },\n    \"Action\": \"SQS:*\",\n    \"Resource\": \"" + this.account.queueArnPrefix() + queue + "\"\n  }\n]\n}")));
        this.client.setQueueAttributes(builder -> builder.queueUrl(this.account.queueUrlPrefix() + queue).attributes(attributes));
    }

    public void deleteQueue(String name) {
        LOG.debug("Deleting SQS queue {}", (Object)name);
        try {
            this.client.deleteQueue(b -> b.queueUrl(this.account.queueUrlPrefix() + name));
        }
        catch (QueueDoesNotExistException queueDoesNotExistException) {
            // empty catch block
        }
    }

    public void sendMessage(String queue, String message) {
        LOG.debug("Sending message \"{}\" to queue {}", (Object)message, (Object)queue);
        this.client.sendMessage(b -> b.queueUrl(this.account.queueUrlPrefix() + queue).messageBody(message));
    }

    public List<Message> getMessages(String queue, int count) {
        return this.getMessages(queue, null, count);
    }

    public List<Message> getMessages(String queue, Collection<String> attributeNames, int count) {
        return (List)WaitUtils.withTimeout(() -> {
            ArrayList<Message> messages = new ArrayList<Message>();
            while (messages.size() != count) {
                List current = this.client.receiveMessage(b -> b.queueUrl(this.account.queueUrlPrefix() + queue).attributeNamesWithStrings(attributeNames).maxNumberOfMessages(Integer.valueOf(10))).messages();
                for (Message m : current) {
                    if (messages.contains(m)) continue;
                    messages.add(m);
                }
            }
            return messages;
        });
    }

    public void deleteMessage(String queue, String receiptHandle) {
        LOG.debug("Deleting message with receipt handle {} from queue {}", (Object)receiptHandle, (Object)queue);
        this.client.deleteMessage(b -> b.queueUrl(this.account.queueUrlPrefix() + queue).receiptHandle(receiptHandle));
    }

    public boolean queueExists(String queue) {
        return this.client.listQueues(b -> b.queueNamePrefix(queue)).queueUrls().stream().anyMatch(url -> queue.equals(StringUtils.substringAfterLast((String)url, (String)"/")));
    }

    public int getQueueSize(String queue) {
        return Integer.parseInt((String)this.client.getQueueAttributes(qab -> qab.queueUrl(this.client.getQueueUrl(qub -> qub.queueName(queue)).queueUrl()).attributeNames(new QueueAttributeName[]{QueueAttributeName.APPROXIMATE_NUMBER_OF_MESSAGES})).attributes().get(QueueAttributeName.APPROXIMATE_NUMBER_OF_MESSAGES));
    }

    public void purgeQueue(String queue) {
        LOG.debug("Purging SQS queue {}", (Object)queue);
        try {
            this.client.purgeQueue(b -> b.queueUrl(this.account.queueUrlPrefix() + queue));
            WaitUtils.sleep((long)60000L);
        }
        catch (QueueDoesNotExistException queueDoesNotExistException) {
            // empty catch block
        }
    }
}

