/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.sqs.service;

import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.tnb.aws.common.account.AWSAccount;
import software.tnb.aws.common.service.AWSService;
import software.tnb.aws.common.service.configuration.AWSConfiguration;
import software.tnb.aws.sqs.account.SQSAccount;
import software.tnb.aws.sqs.validation.SQSValidation;
import software.tnb.common.account.AccountFactory;

@AutoService(value={SQS.class})
public class SQS
extends AWSService<SQSAccount, SqsClient, SQSValidation> {
    private static final Logger LOG = LoggerFactory.getLogger(SQS.class);

    public SQSAccount account() {
        if (this.account == null) {
            LOG.debug("Creating new SQS account");
            this.account = (AWSAccount)AccountFactory.create(SQSAccount.class);
            if (((AWSConfiguration)this.getConfiguration()).isLocalstack()) {
                ((SQSAccount)this.account).setAccount_id("000000000000");
            }
            ((SQSAccount)this.account).setQueueUrlPrefix(String.format("https://sqs.%s.amazonaws.com/%s/", ((SQSAccount)this.account).region(), ((SQSAccount)this.account).accountId()));
            ((SQSAccount)this.account).setQueueArnPrefix(String.format("arn:aws:sqs:%s:%s:", ((SQSAccount)this.account).region(), ((SQSAccount)this.account).accountId()));
        }
        return (SQSAccount)this.account;
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        super.beforeAll(extensionContext);
        LOG.debug("Creating new SQS validation");
        this.validation = new SQSValidation((SqsClient)this.client(SqsClient.class), this.account());
    }
}

