/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.lambda.service;

import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.tnb.aws.common.account.AWSAccount;
import software.tnb.aws.common.service.AWSService;
import software.tnb.aws.iam.service.IAM;
import software.tnb.aws.lambda.validation.LambdaValidation;
import software.tnb.common.service.ServiceFactory;

@AutoService(value={Lambda.class})
public class Lambda
extends AWSService<AWSAccount, LambdaClient, LambdaValidation> {
    private final IAM iam = (IAM)ServiceFactory.create(IAM.class);

    public void afterAll(ExtensionContext context) throws Exception {
        this.iam.afterAll(context);
        super.afterAll(context);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        super.beforeAll(context);
        this.iam.beforeAll(context);
        LOG.debug("Creating new Lambda validation");
        this.validation = new LambdaValidation((LambdaClient)this.client(), this.iam);
    }
}

