/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.lambda.validation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.model.FunctionCode;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.InvalidParameterValueException;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.tnb.aws.iam.service.IAM;
import software.tnb.aws.iam.validation.IAMValidation;
import software.tnb.common.utils.WaitUtils;
import software.tnb.common.validation.Validation;

public class LambdaValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(LambdaValidation.class);
    private static final String ROLE_NAME = "tnb-lambda-role";
    private final LambdaClient client;
    private final IAM iam;

    public LambdaValidation(LambdaClient client, IAM iam) {
        this.client = client;
        this.iam = iam;
    }

    public void createFunction(String name, Runtime runtime, String handler, Path zipFile) {
        try (InputStream is = Files.newInputStream(zipFile, new OpenOption[0]);){
            this.createFunction(name, runtime, handler, SdkBytes.fromInputStream((InputStream)is));
        }
        catch (IOException e) {
            Assertions.fail((String)"Unable to load function from zip file: ", (Throwable)e);
        }
    }

    public void createFunction(String name, Runtime runtime, String handler, SdkBytes zipFile) {
        LOG.info("Creating Lambda function with name {}", (Object)name);
        String rolePolicy = null;
        try (InputStream is = this.getClass().getResourceAsStream("/role-policy.json");){
            rolePolicy = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            Assertions.fail((String)"Unable to read role-policy.json file", (Throwable)e);
        }
        String roleArn = ((IAMValidation)this.iam.validation()).createRole(ROLE_NAME, "Used in TNB lambda service, if deleted, it will be automatically recreated when running the tests again", rolePolicy);
        for (int retries = 0; retries < 12; ++retries) {
            try {
                this.client.createFunction(builder -> builder.functionName(name).role(roleArn).runtime(runtime).handler(handler).publish(Boolean.valueOf(true)).code((FunctionCode)FunctionCode.builder().zipFile(zipFile).build()));
                break;
            }
            catch (InvalidParameterValueException ex) {
                if (ex.getMessage().contains("The role defined for the function cannot be assumed by Lambda")) {
                    LOG.trace("Role not ready yet, will be retried");
                    WaitUtils.sleep((long)5000L);
                    continue;
                }
                throw new RuntimeException("Unable to create lambda function: ", ex);
            }
        }
    }

    public GetFunctionResponse getFunction(String name) {
        try {
            return this.client.getFunction(b -> b.functionName(name).build());
        }
        catch (ResourceNotFoundException ex) {
            return null;
        }
    }

    public InvokeResponse invokeFunction(String name, SdkBytes bytes) {
        return this.client.invoke(b -> b.functionName(name).payload(bytes));
    }

    public void deleteFunction(String name) {
        LOG.debug("Deleting Lambda function {}", (Object)name);
        try {
            this.client.deleteFunction(b -> b.functionName(name));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
    }

    public List<FunctionConfiguration> listFunctions() {
        return this.client.listFunctions().functions();
    }

    public String getRoleArn() {
        return (String)((IAMValidation)this.iam.validation()).getRoleArn(ROLE_NAME).get();
    }
}

