/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.firehose.validation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.firehose.FirehoseClient;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus;
import software.amazon.awssdk.services.firehose.model.InvalidArgumentException;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import software.tnb.aws.iam.service.IAM;
import software.tnb.aws.iam.validation.IAMValidation;
import software.tnb.common.utils.WaitUtils;
import software.tnb.common.validation.Validation;

public class KinesisFirehoseValidation
implements Validation {
    private static final String ROLE_NAME = "tnb-kinesis-firehose-role";
    private static final Logger LOG = LoggerFactory.getLogger(KinesisFirehoseValidation.class);
    private final FirehoseClient client;
    private final IAM iam;

    public KinesisFirehoseValidation(FirehoseClient client, IAM iam) {
        this.client = client;
        this.iam = iam;
    }

    public void createStream(String bucketARN, String streamName) {
        String rolePolicy = null;
        try (InputStream is = this.getClass().getResourceAsStream("/role-policy.json");){
            rolePolicy = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            Assertions.fail((String)"Unable to read role-policy.json file", (Throwable)e);
        }
        String roleArn = ((IAMValidation)this.iam.validation()).createRole(ROLE_NAME, "Used in TNB Kinesis Firehose service, if deleted, it will be automatically recreated when running the tests again", rolePolicy);
        ((IAMValidation)this.iam.validation()).attachPolicy(ROLE_NAME, "arn:aws:iam::aws:policy/AmazonS3FullAccess");
        String kinesisPrefix = "myFirehose/testfile=!{firehose:random-string}";
        LOG.debug("Creating Kinesis firehose stream {}", (Object)streamName);
        for (int retries = 0; retries < 12; ++retries) {
            try {
                this.client.createDeliveryStream(b -> b.deliveryStreamName(streamName).extendedS3DestinationConfiguration(builder -> builder.bucketARN(bucketARN).roleARN(roleArn).prefix(kinesisPrefix).errorOutputPrefix("error").processingConfiguration(builder1 -> builder1.enabled(Boolean.valueOf(false))).dataFormatConversionConfiguration(builder1 -> builder1.enabled(Boolean.valueOf(false))).bufferingHints(builder1 -> builder1.intervalInSeconds(Integer.valueOf(60)).sizeInMBs(Integer.valueOf(1)))).deliveryStreamType("DirectPut"));
                break;
            }
            catch (InvalidArgumentException ex) {
                if (ex.getMessage().contains("Firehose is unable to assume role")) {
                    LOG.trace("Role not ready yet, will be retried");
                    WaitUtils.sleep((long)5000L);
                    continue;
                }
                throw new RuntimeException("Unable to create lambda function: ", ex);
            }
        }
        WaitUtils.waitFor(() -> this.client.describeDeliveryStream(b -> b.deliveryStreamName(streamName).build()).deliveryStreamDescription().deliveryStreamStatus() == DeliveryStreamStatus.ACTIVE, (String)"Waiting until the Firehose stream is active");
    }

    public void sendMessage(String stream, String message) {
        this.client.putRecord(builder -> builder.deliveryStreamName(stream).record(b -> b.data(SdkBytes.fromUtf8String((String)message))));
    }

    public void deleteDataStream(String name) {
        LOG.debug("Deleting Kinesis Firehose data stream {}", (Object)name);
        this.client.deleteDeliveryStream(builder -> builder.deliveryStreamName(name));
    }

    public List<String> listDeliveryStreams() {
        return this.client.listDeliveryStreams(SdkBuilder::build).deliveryStreamNames();
    }
}

