/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.firehose.service;

import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.amazon.awssdk.services.firehose.FirehoseClient;
import software.tnb.aws.common.account.AWSAccount;
import software.tnb.aws.common.service.AWSService;
import software.tnb.aws.firehose.validation.KinesisFirehoseValidation;
import software.tnb.aws.iam.service.IAM;
import software.tnb.common.service.ServiceFactory;

@AutoService(value={KinesisFirehose.class})
public class KinesisFirehose
extends AWSService<AWSAccount, FirehoseClient, KinesisFirehoseValidation> {
    private final IAM iam = (IAM)ServiceFactory.create(IAM.class);

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        super.beforeAll(extensionContext);
        this.iam.beforeAll(extensionContext);
        LOG.debug("Creating new Kinesis validation");
        this.validation = new KinesisFirehoseValidation((FirehoseClient)this.client(), this.iam);
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.iam.afterAll(extensionContext);
        super.afterAll(extensionContext);
    }
}

