/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.dynamodb.service;

import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.tnb.aws.common.account.AWSAccount;
import software.tnb.aws.common.client.AWSClient;
import software.tnb.aws.common.service.AWSService;
import software.tnb.aws.common.service.configuration.AWSConfiguration;
import software.tnb.aws.dynamodb.validation.DynamoDBValidation;

@AutoService(value={DynamoDB.class})
public class DynamoDB
extends AWSService<AWSAccount, DynamoDbClient, DynamoDBValidation> {
    private DynamoDbStreamsClient streamsClient;

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        super.beforeAll(extensionContext);
        LOG.debug("Creating new DynamoDB validation");
        this.streamsClient = (DynamoDbStreamsClient)AWSClient.createDefaultClient((AWSAccount)this.account(), DynamoDbStreamsClient.class, ((AWSConfiguration)this.getConfiguration()).isLocalstack() ? this.localStack.clientUrl() : null);
        this.validation = new DynamoDBValidation((DynamoDbClient)this.client(), this.streamsClient);
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        super.afterAll(extensionContext);
        if (this.streamsClient != null) {
            this.streamsClient.close();
        }
    }
}

