/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.cloudwatch.validation;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.Metric;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataResult;
import software.amazon.awssdk.services.cloudwatch.model.MetricStat;
import software.tnb.common.service.Validation;

public class CloudwatchValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(CloudwatchValidation.class);
    private final CloudWatchClient client;

    public CloudwatchValidation(CloudWatchClient client) {
        this.client = client;
    }

    public List<MetricDataResult> getMetrics(String namespace, String metricName, Instant start) {
        LOG.debug("Fetching Couldwatch metrics {} from namespace {}", (Object)metricName, (Object)namespace);
        List<Object> data = new ArrayList<MetricDataResult>();
        Instant endDate = Instant.now();
        Metric met = (Metric)Metric.builder().metricName(metricName).namespace(namespace).build();
        MetricStat metStat = (MetricStat)MetricStat.builder().stat("Minimum").period(Integer.valueOf(60)).metric(met).build();
        MetricDataQuery dataQUery = (MetricDataQuery)MetricDataQuery.builder().metricStat(metStat).id("foo2").returnData(Boolean.valueOf(true)).build();
        ArrayList<MetricDataQuery> dq = new ArrayList<MetricDataQuery>();
        dq.add(dataQUery);
        GetMetricDataRequest getMetReq = (GetMetricDataRequest)GetMetricDataRequest.builder().maxDatapoints(Integer.valueOf(100)).startTime(start).endTime(endDate).metricDataQueries(dq).build();
        GetMetricDataResponse response = this.client.getMetricData(getMetReq);
        if (response.hasMetricDataResults()) {
            data = response.metricDataResults();
        }
        return data;
    }
}

