/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.cloudwatch.validation.model;

import java.time.Instant;
import org.apache.commons.lang3.RandomStringUtils;
import software.tnb.aws.cloudwatch.validation.model.Stat;

public class MetricsRequest {
    private String metricName;
    private String namespace;
    private String stat;
    private int maxDataPoints;
    private int period;
    private Instant start;
    private Instant end;
    private String queryId;

    public String metricName() {
        return this.metricName;
    }

    public String namespace() {
        return this.namespace;
    }

    public String stat() {
        return this.stat;
    }

    public int maxDataPoints() {
        return this.maxDataPoints;
    }

    public int period() {
        return this.period;
    }

    public Instant start() {
        return this.start;
    }

    public Instant end() {
        return this.end;
    }

    public String queryId() {
        return this.queryId;
    }

    public static final class MetricsRequestBuilder {
        private String metricName;
        private String namespace;
        private String stat;
        private int maxDataPoints = 100;
        private int period = 60;
        private Instant start;
        private Instant end = Instant.now();
        private String queryId = RandomStringUtils.randomAlphabetic((int)8).toLowerCase();

        public MetricsRequestBuilder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public MetricsRequestBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public MetricsRequestBuilder stat(Stat stat) {
            this.stat = stat.value();
            return this;
        }

        public MetricsRequestBuilder stat(String stat) {
            this.stat = stat;
            return this;
        }

        public MetricsRequestBuilder maxDataPoints(int maxDataPoints) {
            this.maxDataPoints = maxDataPoints;
            return this;
        }

        public MetricsRequestBuilder period(int period) {
            this.period = period;
            return this;
        }

        public MetricsRequestBuilder start(Instant start) {
            this.start = start;
            return this;
        }

        public MetricsRequestBuilder end(Instant end) {
            this.end = end;
            return this;
        }

        public MetricsRequestBuilder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public MetricsRequest build() {
            if (this.metricName == null || this.namespace == null || this.stat == null || this.start == null) {
                throw new IllegalArgumentException("At least one required parameter missing. Required parameters are metricName, namespace, stat, start");
            }
            MetricsRequest metricsRequest = new MetricsRequest();
            metricsRequest.maxDataPoints = this.maxDataPoints;
            metricsRequest.start = this.start;
            metricsRequest.metricName = this.metricName;
            metricsRequest.end = this.end;
            metricsRequest.namespace = this.namespace;
            metricsRequest.stat = this.stat;
            metricsRequest.queryId = this.queryId;
            metricsRequest.period = this.period;
            return metricsRequest;
        }
    }
}

