/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.cloudwatch.validation;

import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataResult;
import software.tnb.aws.cloudwatch.validation.model.MetricsRequest;
import software.tnb.common.service.Validation;

public class CloudwatchValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(CloudwatchValidation.class);
    private final CloudWatchClient client;

    public CloudwatchValidation(CloudWatchClient client) {
        this.client = client;
    }

    public List<MetricDataResult> getMetrics(Consumer<MetricsRequest.MetricsRequestBuilder> requestBuilder) {
        MetricsRequest.MetricsRequestBuilder builder = new MetricsRequest.MetricsRequestBuilder();
        requestBuilder.accept(builder);
        MetricsRequest request = builder.build();
        LOG.debug("Fetching Couldwatch metrics {} from namespace {}", (Object)request.metricName(), (Object)request.namespace());
        GetMetricDataResponse response = this.client.getMetricData(b -> b.maxDatapoints(Integer.valueOf(request.maxDataPoints())).startTime(request.start()).endTime(request.end()).metricDataQueries(new Consumer[]{dq -> dq.id(request.queryId()).returnData(Boolean.valueOf(true)).metricStat(ms -> ms.stat(request.stat()).period(Integer.valueOf(request.period())).metric(m -> m.metricName(request.metricName()).namespace(request.namespace())))}));
        return response.hasMetricDataResults() ? response.metricDataResults() : List.of();
    }

    public ListMetricsResponse listMetrics(String namespace, String metricName) {
        LOG.debug("Fetching Couldwatch metric {} from namespace {}", (Object)metricName, (Object)namespace);
        return this.client.listMetrics(b -> b.metricName(metricName).namespace(namespace));
    }
}

