/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.jms.amq.resource.openshift;

import com.google.auto.service.AutoService;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShiftWaiters;
import cz.xtf.core.openshift.helpers.ResourceFunctions;
import cz.xtf.core.openshift.helpers.ResourceParsers;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.deployment.WithExternalHostname;
import software.tnb.common.deployment.WithInClusterHostname;
import software.tnb.common.deployment.WithOperatorHub;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.jms.amq.resource.openshift.generated.Acceptor;
import software.tnb.jms.amq.resource.openshift.generated.ActiveMQArtemis;
import software.tnb.jms.amq.resource.openshift.generated.ActiveMQArtemisList;
import software.tnb.jms.amq.resource.openshift.generated.ActiveMQArtemisSpec;
import software.tnb.jms.amq.resource.openshift.generated.DeploymentPlan;
import software.tnb.jms.amq.service.AMQBroker;

@AutoService(value={AMQBroker.class})
public class OpenshiftAMQBroker
extends AMQBroker
implements OpenshiftDeployable,
WithInClusterHostname,
WithExternalHostname,
WithOperatorHub {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftAMQBroker.class);
    public static final String BROKER_NAME = "tnb-amq-broker";
    private static final String SSL_SECRET_NAME = "tnb-ssl-secret";
    private static final CustomResourceDefinitionContext ARTEMIS_CTX = new CustomResourceDefinitionContext.Builder().withName("ActiveMQArtemis").withGroup("broker.amq.io").withVersion("v2alpha5").withPlural("activemqartemises").withScope("Namespaced").build();

    public void create() {
        LOG.debug("Creating AMQ broker");
        this.createSubscription();
        this.amqBrokerCli().createOrReplace((Object[])new ActiveMQArtemis[]{this.createBrokerCR()});
    }

    public boolean isReady() {
        return (Boolean)ResourceFunctions.areExactlyNPodsReady((int)1).apply(OpenshiftClient.get().getLabeledPods("ActiveMQArtemis", BROKER_NAME));
    }

    public boolean isDeployed() {
        List pods = ((PodList)((FilterWatchListDeletable)OpenshiftClient.get().pods().withLabel("name", "amq-broker-operator")).list()).getItems();
        return pods.size() == 1 && ResourceParsers.isPodReady((Pod)((Pod)pods.get(0))) && ((ActiveMQArtemisList)((Object)this.amqBrokerCli().list())).getItems().size() > 0;
    }

    public String inClusterHostname() {
        String podName = ((Pod)OpenshiftClient.get().getLabeledPods("ActiveMQArtemis", BROKER_NAME).get(0)).getMetadata().getName();
        return String.format("%s.%s-hdls-svc.%s.svc.cluster.local", podName, BROKER_NAME, OpenshiftClient.get().getNamespace());
    }

    public String externalHostname() {
        List routes = ((RouteList)((FilterWatchListDeletable)OpenshiftClient.get().routes().withLabel("ActiveMQArtemis", BROKER_NAME)).list()).getItems();
        if (routes.size() != 1) {
            throw new RuntimeException("Expected single route to be present but was " + routes.size());
        }
        return ((Route)routes.get(0)).getSpec().getHost();
    }

    public void undeploy() {
        ((EditReplacePatchDeletable)((Resource)this.amqBrokerCli().withName(BROKER_NAME)).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        OpenShiftWaiters.get((OpenShift)OpenshiftClient.get(), () -> false).areExactlyNPodsRunning(0, "ActiveMQArtemis", BROKER_NAME).timeout(120000L).waitFor();
        OpenshiftClient.get().deleteSecret(SSL_SECRET_NAME);
        this.deleteSubscription(() -> OpenshiftClient.get().getLabeledPods("name", "amq-broker-operator").isEmpty());
    }

    public void openResources() {
        this.connection = this.createConnection();
    }

    public void closeResources() {
        try {
            this.connection.close();
        }
        catch (JMSException e) {
            throw new RuntimeException("Can't close JMS connection");
        }
    }

    @Override
    public String brokerUrl() {
        return this.inClusterHostname();
    }

    @Override
    protected String mqttUrl() {
        return String.format("ssl://%s:443", this.externalHostname());
    }

    @Override
    public int getPortMapping(int port) {
        return 61626;
    }

    private Connection createConnection() {
        try {
            String tsPath = this.materializeTrustStore().toAbsolutePath().toString();
            System.setProperty("org.apache.activemq.ssl.trustStore", tsPath);
            System.setProperty("org.apache.activemq.ssl.trustStorePassword", this.account().truststorePassword());
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(String.format("tcp://%s:%s?useTopologyForLoadBalancing=false&sslEnabled=true&verifyHost=false", this.externalHostname(), 443), this.account().username(), this.account().password());
            Connection connection = connectionFactory.createConnection();
            connection.start();
            return connection;
        }
        catch (JMSException e) {
            throw new RuntimeException("Can't create jms connection", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't materialize jms truststore", e);
        }
    }

    private ActiveMQArtemis createBrokerCR() {
        Map<String, String> data = Map.of("keyStorePassword", this.encode(this.account().keystorePassword().getBytes()), "trustStorePassword", this.encode(this.account().truststorePassword().getBytes()), "client.ts", this.encodeResource("broker.ts"), "broker.ks", this.encodeResource("broker.ks"));
        SecretBuilder sb = (SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().editOrNewMetadata().withName(SSL_SECRET_NAME)).endMetadata()).withData(data);
        OpenshiftClient.get().secrets().createOrReplace((Object[])new Secret[]{sb.build()});
        ActiveMQArtemis broker = new ActiveMQArtemis();
        broker.getMetadata().setName(BROKER_NAME);
        DeploymentPlan dp = new DeploymentPlan();
        dp.setSize(1);
        dp.setImage("placeholder");
        dp.setRequireLogin(false);
        dp.setPersistenceEnabled(false);
        dp.setJournalType("nio");
        dp.setMessageMigration(true);
        broker.setSpec(new ActiveMQArtemisSpec());
        ((ActiveMQArtemisSpec)broker.getSpec()).setDeploymentPlan(dp);
        ((ActiveMQArtemisSpec)broker.getSpec()).setAdminUser(this.account().username());
        ((ActiveMQArtemisSpec)broker.getSpec()).setAdminPassword(this.account().password());
        Acceptor acceptor = new Acceptor();
        acceptor.setName("all-ssl");
        acceptor.setProtocols("all");
        acceptor.setPort(61636);
        acceptor.setExpose(true);
        acceptor.setSslEnabled(true);
        acceptor.setSslSecret(SSL_SECRET_NAME);
        Acceptor internal = new Acceptor();
        internal.setName("all-internal");
        internal.setProtocols("all");
        internal.setPort(61626);
        internal.setExpose(false);
        internal.setSslEnabled(false);
        ArrayList<Acceptor> acceptors = new ArrayList<Acceptor>();
        acceptors.add(acceptor);
        acceptors.add(internal);
        ((ActiveMQArtemisSpec)broker.getSpec()).setAcceptors(acceptors);
        return broker;
    }

    private Path materializeTrustStore() throws IOException {
        Path ts = Paths.get("target", "tnb-trust-store" + new Date().getTime() + ".ts");
        try (InputStream is = this.getClass().getResourceAsStream("/client.ts");){
            Files.copy(is, ts, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create truststore", e);
        }
        return ts;
    }

    private String encode(byte[] content) {
        return Base64.getEncoder().encodeToString(content);
    }

    private String encodeResource(String resource) {
        try {
            return this.encode(IOUtils.toByteArray((URL)this.getClass().getResource("/" + resource)));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to encode resource " + resource, e);
        }
    }

    private NonNamespaceOperation<ActiveMQArtemis, ActiveMQArtemisList, Resource<ActiveMQArtemis>> amqBrokerCli() {
        return OpenshiftClient.get().customResources((ResourceDefinitionContext)ARTEMIS_CTX, ActiveMQArtemis.class, ActiveMQArtemisList.class).inNamespace(OpenshiftClient.get().getNamespace());
    }

    public String operatorChannel() {
        return "7.10.x";
    }

    public String operatorName() {
        return "amq-broker-rhel8";
    }
}

