/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.jms.amq.service.openshift.generated;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"deadLetterAddress", "autoCreateDeadLetterResources", "deadLetterQueuePrefix", "deadLetterQueueSuffix", "expiryAddress", "autoCreateExpiryResources", "expiryQueuePrefix", "expiryQueueSuffix", "expiryDelay", "minExpiryDelay", "maxExpiryDelay", "redeliveryDelay", "redeliveryDelayMultiplier", "redeliveryCollisionAvoidanceFactor", "maxRedeliveryDelay", "maxDeliveryAttempts", "maxSizeBytes", "maxSizeBytesRejectThreshold", "pageSizeBytes", "pageMaxCacheSize", "addressFullPolicy", "messageCounterHistoryDayLimit", "lastValueQueue", "defaultLastValueQueue", "defaultLastValueKey", "defaultNonDestructive", "defaultExclusiveQueue", "defaultGroupRebalance", "defaultGroupRebalancePauseDispatch", "defaultGroupBuckets", "defaultGroupFirstKey", "defaultConsumersBeforeDispatch", "defaultDelayBeforeDispatch", "redistributionDelay", "sendToDlaOnNoRoute", "slowConsumerThreshold", "slowConsumerPolicy", "slowConsumerCheckPeriod", "autoCreateJmsQueues", "autoDeleteJmsQueues", "autoCreateJmsTopics", "autoDeleteJmsTopics", "autoCreateQueues", "autoDeleteQueues", "autoDeleteCreatedQueues", "autoDeleteQueuesDelay", "autoDeleteQueuesMessageCount", "configDeleteQueues", "autoCreateAddresses", "autoDeleteAddresses", "autoDeleteAddressesDelay", "configDeleteAddresses", "managementBrowsePageSize", "defaultPurgeOnNoConsumers", "defaultMaxConsumers", "defaultQueueRoutingType", "defaultAddressRoutingType", "defaultConsumerWindowSize", "defaultRingSize", "retroactiveMessageCount", "enableMetrics", "match"})
public class AddressSetting
implements KubernetesResource {
    @JsonProperty(value="deadLetterAddress")
    @JsonPropertyDescription(value="the address to send dead messages to")
    private String deadLetterAddress;
    @JsonProperty(value="autoCreateDeadLetterResources")
    @JsonPropertyDescription(value="whether or not to automatically create the dead-letter-address and/or a corresponding queue on that address when a message found to be undeliverable")
    private Boolean autoCreateDeadLetterResources;
    @JsonProperty(value="deadLetterQueuePrefix")
    @JsonPropertyDescription(value="the prefix to use for auto-created dead letter queues")
    private String deadLetterQueuePrefix;
    @JsonProperty(value="deadLetterQueueSuffix")
    @JsonPropertyDescription(value="the suffix to use for auto-created dead letter queues")
    private String deadLetterQueueSuffix;
    @JsonProperty(value="expiryAddress")
    @JsonPropertyDescription(value="the address to send expired messages to")
    private String expiryAddress;
    @JsonProperty(value="autoCreateExpiryResources")
    @JsonPropertyDescription(value="whether or not to automatically create the expiry-address and/or a corresponding queue on that address when a message is sent to a matching queue")
    private Boolean autoCreateExpiryResources;
    @JsonProperty(value="expiryQueuePrefix")
    @JsonPropertyDescription(value="the prefix to use for auto-created expiry queues")
    private String expiryQueuePrefix;
    @JsonProperty(value="expiryQueueSuffix")
    @JsonPropertyDescription(value="the suffix to use for auto-created expiry queues")
    private String expiryQueueSuffix;
    @JsonProperty(value="expiryDelay")
    @JsonPropertyDescription(value="Overrides the expiration time for messages using the default value for expiration time. \"-1\" disables this setting.")
    private Integer expiryDelay;
    @JsonProperty(value="minExpiryDelay")
    @JsonPropertyDescription(value="Overrides the expiration time for messages using a lower value. \"-1\" disables this setting.")
    private Integer minExpiryDelay;
    @JsonProperty(value="maxExpiryDelay")
    @JsonPropertyDescription(value="Overrides the expiration time for messages using a higher value. \"-1\" disables this setting.")
    private Integer maxExpiryDelay;
    @JsonProperty(value="redeliveryDelay")
    @JsonPropertyDescription(value="the time (in ms) to wait before redelivering a cancelled message.")
    private Integer redeliveryDelay;
    @JsonProperty(value="redeliveryDelayMultiplier")
    @JsonPropertyDescription(value="multiplier to apply to the redelivery-delay")
    private Double redeliveryDelayMultiplier;
    @JsonProperty(value="redeliveryCollisionAvoidanceFactor")
    @JsonPropertyDescription(value="factor by which to modify the redelivery delay slightly to avoid collisions")
    private Double redeliveryCollisionAvoidanceFactor;
    @JsonProperty(value="maxRedeliveryDelay")
    @JsonPropertyDescription(value="Maximum value for the redelivery-delay")
    private Integer maxRedeliveryDelay;
    @JsonProperty(value="maxDeliveryAttempts")
    @JsonPropertyDescription(value="how many times to attempt to deliver a message before sending to dead letter address")
    private Integer maxDeliveryAttempts;
    @JsonProperty(value="maxSizeBytes")
    @JsonPropertyDescription(value="the maximum size in bytes for an address. -1 means no limits. This is used in PAGING, BLOCK and FAIL policies. Supports byte notation like K, Mb, GB, etc.")
    private String maxSizeBytes;
    @JsonProperty(value="maxSizeBytesRejectThreshold")
    @JsonPropertyDescription(value="used with the address full BLOCK policy, the maximum size in bytes an address can reach before messages start getting rejected. Works in combination with max-size-bytes for AMQP protocol only. Default = -1 (no limit).")
    private Integer maxSizeBytesRejectThreshold;
    @JsonProperty(value="pageSizeBytes")
    @JsonPropertyDescription(value="The page size in bytes to use for an address. Supports byte notation like K, Mb, GB, etc.")
    private String pageSizeBytes;
    @JsonProperty(value="pageMaxCacheSize")
    @JsonPropertyDescription(value="Number of paging files to cache in memory to avoid IO during paging navigation")
    private Integer pageMaxCacheSize;
    @JsonProperty(value="addressFullPolicy")
    @JsonPropertyDescription(value="what happens when an address where maxSizeBytes is specified becomes full")
    private AddressFullPolicy addressFullPolicy;
    @JsonProperty(value="messageCounterHistoryDayLimit")
    @JsonPropertyDescription(value="how many days to keep message counter history for this address")
    private Integer messageCounterHistoryDayLimit;
    @JsonProperty(value="lastValueQueue")
    @JsonPropertyDescription(value="This is deprecated please use default-last-value-queue instead.")
    private Boolean lastValueQueue;
    @JsonProperty(value="defaultLastValueQueue")
    @JsonPropertyDescription(value="whether to treat the queues under the address as a last value queues by default")
    private Boolean defaultLastValueQueue;
    @JsonProperty(value="defaultLastValueKey")
    @JsonPropertyDescription(value="the property to use as the key for a last value queue by default")
    private String defaultLastValueKey;
    @JsonProperty(value="defaultNonDestructive")
    @JsonPropertyDescription(value="whether the queue should be non-destructive by default")
    private Boolean defaultNonDestructive;
    @JsonProperty(value="defaultExclusiveQueue")
    @JsonPropertyDescription(value="whether to treat the queues under the address as exclusive queues by default")
    private Boolean defaultExclusiveQueue;
    @JsonProperty(value="defaultGroupRebalance")
    @JsonPropertyDescription(value="whether to rebalance groups when a consumer is added")
    private Boolean defaultGroupRebalance;
    @JsonProperty(value="defaultGroupRebalancePauseDispatch")
    @JsonPropertyDescription(value="whether to pause dispatch when rebalancing groups")
    private Boolean defaultGroupRebalancePauseDispatch;
    @JsonProperty(value="defaultGroupBuckets")
    @JsonPropertyDescription(value="number of buckets to use for grouping, -1 (default) is unlimited and uses the raw group, 0 disables message groups.")
    private Integer defaultGroupBuckets;
    @JsonProperty(value="defaultGroupFirstKey")
    @JsonPropertyDescription(value="key used to mark a message is first in a group for a consumer")
    private String defaultGroupFirstKey;
    @JsonProperty(value="defaultConsumersBeforeDispatch")
    @JsonPropertyDescription(value="the default number of consumers needed before dispatch can start for queues under the address.")
    private Integer defaultConsumersBeforeDispatch;
    @JsonProperty(value="defaultDelayBeforeDispatch")
    @JsonPropertyDescription(value="the default delay (in milliseconds) to wait before dispatching if number of consumers before dispatch is not met for queues under the address.")
    private Integer defaultDelayBeforeDispatch;
    @JsonProperty(value="redistributionDelay")
    @JsonPropertyDescription(value="how long (in ms) to wait after the last consumer is closed on a queue before redistributing messages.")
    private Integer redistributionDelay;
    @JsonProperty(value="sendToDlaOnNoRoute")
    @JsonPropertyDescription(value="if there are no queues matching this address, whether to forward message to DLA (if it exists for this address)")
    private Boolean sendToDlaOnNoRoute;
    @JsonProperty(value="slowConsumerThreshold")
    @JsonPropertyDescription(value="The minimum rate of message consumption allowed before a consumer is considered \"slow.\" Measured in messages-per-second.")
    private Integer slowConsumerThreshold;
    @JsonProperty(value="slowConsumerPolicy")
    @JsonPropertyDescription(value="what happens when a slow consumer is identified")
    private SlowConsumerPolicy slowConsumerPolicy;
    @JsonProperty(value="slowConsumerCheckPeriod")
    @JsonPropertyDescription(value="How often to check for slow consumers on a particular queue. Measured in seconds.")
    private Integer slowConsumerCheckPeriod;
    @JsonProperty(value="autoCreateJmsQueues")
    @JsonPropertyDescription(value="DEPRECATED. whether or not to automatically create JMS queues when a producer sends or a consumer connects to a queue")
    private Boolean autoCreateJmsQueues;
    @JsonProperty(value="autoDeleteJmsQueues")
    @JsonPropertyDescription(value="DEPRECATED. whether or not to delete auto-created JMS queues when the queue has 0 consumers and 0 messages")
    private Boolean autoDeleteJmsQueues;
    @JsonProperty(value="autoCreateJmsTopics")
    @JsonPropertyDescription(value="DEPRECATED. whether or not to automatically create JMS topics when a producer sends or a consumer subscribes to a topic")
    private Boolean autoCreateJmsTopics;
    @JsonProperty(value="autoDeleteJmsTopics")
    @JsonPropertyDescription(value="DEPRECATED. whether or not to delete auto-created JMS topics when the last subscription is closed")
    private Boolean autoDeleteJmsTopics;
    @JsonProperty(value="autoCreateQueues")
    @JsonPropertyDescription(value="whether or not to automatically create a queue when a client sends a message to or attempts to consume a message from a queue")
    private Boolean autoCreateQueues;
    @JsonProperty(value="autoDeleteQueues")
    @JsonPropertyDescription(value="whether or not to delete auto-created queues when the queue has 0 consumers and 0 messages")
    private Boolean autoDeleteQueues;
    @JsonProperty(value="autoDeleteCreatedQueues")
    @JsonPropertyDescription(value="whether or not to delete created queues when the queue has 0 consumers and 0 messages")
    private Boolean autoDeleteCreatedQueues;
    @JsonProperty(value="autoDeleteQueuesDelay")
    @JsonPropertyDescription(value="how long to wait (in milliseconds) before deleting auto-created queues after the queue has 0 consumers.")
    private Integer autoDeleteQueuesDelay;
    @JsonProperty(value="autoDeleteQueuesMessageCount")
    @JsonPropertyDescription(value="the message count the queue must be at or below before it can be evaluated  to be auto deleted, 0 waits until empty queue (default) and -1 disables this check.")
    private Integer autoDeleteQueuesMessageCount;
    @JsonProperty(value="configDeleteQueues")
    @JsonPropertyDescription(value="What to do when a queue is no longer in broker.xml. OFF = will do nothing queues will remain, FORCE = delete queues even if messages remaining.")
    private ConfigDeleteQueues configDeleteQueues;
    @JsonProperty(value="autoCreateAddresses")
    @JsonPropertyDescription(value="whether or not to automatically create addresses when a client sends a message to or attempts to consume a message from a queue mapped to an address that doesnt exist")
    private Boolean autoCreateAddresses;
    @JsonProperty(value="autoDeleteAddresses")
    @JsonPropertyDescription(value="whether or not to delete auto-created addresses when it no longer has any queues")
    private Boolean autoDeleteAddresses;
    @JsonProperty(value="autoDeleteAddressesDelay")
    @JsonPropertyDescription(value="how long to wait (in milliseconds) before deleting auto-created addresses after they no longer have any queues")
    private Integer autoDeleteAddressesDelay;
    @JsonProperty(value="configDeleteAddresses")
    @JsonPropertyDescription(value="What to do when an address is no longer in broker.xml. OFF = will do nothing addresses will remain, FORCE = delete address and its queues even if messages remaining.")
    private ConfigDeleteAddresses configDeleteAddresses;
    @JsonProperty(value="managementBrowsePageSize")
    @JsonPropertyDescription(value="how many message a management resource can browse")
    private Integer managementBrowsePageSize;
    @JsonProperty(value="defaultPurgeOnNoConsumers")
    @JsonPropertyDescription(value="purge the contents of the queue once there are no consumers")
    private Boolean defaultPurgeOnNoConsumers;
    @JsonProperty(value="defaultMaxConsumers")
    @JsonPropertyDescription(value="the maximum number of consumers allowed on this queue at any one time")
    private Integer defaultMaxConsumers;
    @JsonProperty(value="defaultQueueRoutingType")
    @JsonPropertyDescription(value="the routing-type used on auto-created queues")
    private DefaultQueueRoutingType defaultQueueRoutingType;
    @JsonProperty(value="defaultAddressRoutingType")
    @JsonPropertyDescription(value="the routing-type used on auto-created addresses")
    private DefaultAddressRoutingType defaultAddressRoutingType;
    @JsonProperty(value="defaultConsumerWindowSize")
    @JsonPropertyDescription(value="the default window size for a consumer")
    private Integer defaultConsumerWindowSize;
    @JsonProperty(value="defaultRingSize")
    @JsonPropertyDescription(value="the default ring-size value for any matching queue which doesnt have ring-size explicitly defined")
    private Integer defaultRingSize;
    @JsonProperty(value="retroactiveMessageCount")
    @JsonPropertyDescription(value="the number of messages to preserve for future queues created on the matching address")
    private Integer retroactiveMessageCount;
    @JsonProperty(value="enableMetrics")
    @JsonPropertyDescription(value="whether or not to enable metrics for metrics plugins on the matching address")
    private Boolean enableMetrics;
    @JsonProperty(value="match")
    @JsonPropertyDescription(value="pattern for matching settings against addresses; can use wildards")
    private String match;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="deadLetterAddress")
    public String getDeadLetterAddress() {
        return this.deadLetterAddress;
    }

    @JsonProperty(value="deadLetterAddress")
    public void setDeadLetterAddress(String deadLetterAddress) {
        this.deadLetterAddress = deadLetterAddress;
    }

    public AddressSetting withDeadLetterAddress(String deadLetterAddress) {
        this.deadLetterAddress = deadLetterAddress;
        return this;
    }

    @JsonProperty(value="autoCreateDeadLetterResources")
    public Boolean getAutoCreateDeadLetterResources() {
        return this.autoCreateDeadLetterResources;
    }

    @JsonProperty(value="autoCreateDeadLetterResources")
    public void setAutoCreateDeadLetterResources(Boolean autoCreateDeadLetterResources) {
        this.autoCreateDeadLetterResources = autoCreateDeadLetterResources;
    }

    public AddressSetting withAutoCreateDeadLetterResources(Boolean autoCreateDeadLetterResources) {
        this.autoCreateDeadLetterResources = autoCreateDeadLetterResources;
        return this;
    }

    @JsonProperty(value="deadLetterQueuePrefix")
    public String getDeadLetterQueuePrefix() {
        return this.deadLetterQueuePrefix;
    }

    @JsonProperty(value="deadLetterQueuePrefix")
    public void setDeadLetterQueuePrefix(String deadLetterQueuePrefix) {
        this.deadLetterQueuePrefix = deadLetterQueuePrefix;
    }

    public AddressSetting withDeadLetterQueuePrefix(String deadLetterQueuePrefix) {
        this.deadLetterQueuePrefix = deadLetterQueuePrefix;
        return this;
    }

    @JsonProperty(value="deadLetterQueueSuffix")
    public String getDeadLetterQueueSuffix() {
        return this.deadLetterQueueSuffix;
    }

    @JsonProperty(value="deadLetterQueueSuffix")
    public void setDeadLetterQueueSuffix(String deadLetterQueueSuffix) {
        this.deadLetterQueueSuffix = deadLetterQueueSuffix;
    }

    public AddressSetting withDeadLetterQueueSuffix(String deadLetterQueueSuffix) {
        this.deadLetterQueueSuffix = deadLetterQueueSuffix;
        return this;
    }

    @JsonProperty(value="expiryAddress")
    public String getExpiryAddress() {
        return this.expiryAddress;
    }

    @JsonProperty(value="expiryAddress")
    public void setExpiryAddress(String expiryAddress) {
        this.expiryAddress = expiryAddress;
    }

    public AddressSetting withExpiryAddress(String expiryAddress) {
        this.expiryAddress = expiryAddress;
        return this;
    }

    @JsonProperty(value="autoCreateExpiryResources")
    public Boolean getAutoCreateExpiryResources() {
        return this.autoCreateExpiryResources;
    }

    @JsonProperty(value="autoCreateExpiryResources")
    public void setAutoCreateExpiryResources(Boolean autoCreateExpiryResources) {
        this.autoCreateExpiryResources = autoCreateExpiryResources;
    }

    public AddressSetting withAutoCreateExpiryResources(Boolean autoCreateExpiryResources) {
        this.autoCreateExpiryResources = autoCreateExpiryResources;
        return this;
    }

    @JsonProperty(value="expiryQueuePrefix")
    public String getExpiryQueuePrefix() {
        return this.expiryQueuePrefix;
    }

    @JsonProperty(value="expiryQueuePrefix")
    public void setExpiryQueuePrefix(String expiryQueuePrefix) {
        this.expiryQueuePrefix = expiryQueuePrefix;
    }

    public AddressSetting withExpiryQueuePrefix(String expiryQueuePrefix) {
        this.expiryQueuePrefix = expiryQueuePrefix;
        return this;
    }

    @JsonProperty(value="expiryQueueSuffix")
    public String getExpiryQueueSuffix() {
        return this.expiryQueueSuffix;
    }

    @JsonProperty(value="expiryQueueSuffix")
    public void setExpiryQueueSuffix(String expiryQueueSuffix) {
        this.expiryQueueSuffix = expiryQueueSuffix;
    }

    public AddressSetting withExpiryQueueSuffix(String expiryQueueSuffix) {
        this.expiryQueueSuffix = expiryQueueSuffix;
        return this;
    }

    @JsonProperty(value="expiryDelay")
    public Integer getExpiryDelay() {
        return this.expiryDelay;
    }

    @JsonProperty(value="expiryDelay")
    public void setExpiryDelay(Integer expiryDelay) {
        this.expiryDelay = expiryDelay;
    }

    public AddressSetting withExpiryDelay(Integer expiryDelay) {
        this.expiryDelay = expiryDelay;
        return this;
    }

    @JsonProperty(value="minExpiryDelay")
    public Integer getMinExpiryDelay() {
        return this.minExpiryDelay;
    }

    @JsonProperty(value="minExpiryDelay")
    public void setMinExpiryDelay(Integer minExpiryDelay) {
        this.minExpiryDelay = minExpiryDelay;
    }

    public AddressSetting withMinExpiryDelay(Integer minExpiryDelay) {
        this.minExpiryDelay = minExpiryDelay;
        return this;
    }

    @JsonProperty(value="maxExpiryDelay")
    public Integer getMaxExpiryDelay() {
        return this.maxExpiryDelay;
    }

    @JsonProperty(value="maxExpiryDelay")
    public void setMaxExpiryDelay(Integer maxExpiryDelay) {
        this.maxExpiryDelay = maxExpiryDelay;
    }

    public AddressSetting withMaxExpiryDelay(Integer maxExpiryDelay) {
        this.maxExpiryDelay = maxExpiryDelay;
        return this;
    }

    @JsonProperty(value="redeliveryDelay")
    public Integer getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    @JsonProperty(value="redeliveryDelay")
    public void setRedeliveryDelay(Integer redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
    }

    public AddressSetting withRedeliveryDelay(Integer redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
        return this;
    }

    @JsonProperty(value="redeliveryDelayMultiplier")
    public Double getRedeliveryDelayMultiplier() {
        return this.redeliveryDelayMultiplier;
    }

    @JsonProperty(value="redeliveryDelayMultiplier")
    public void setRedeliveryDelayMultiplier(Double redeliveryDelayMultiplier) {
        this.redeliveryDelayMultiplier = redeliveryDelayMultiplier;
    }

    public AddressSetting withRedeliveryDelayMultiplier(Double redeliveryDelayMultiplier) {
        this.redeliveryDelayMultiplier = redeliveryDelayMultiplier;
        return this;
    }

    @JsonProperty(value="redeliveryCollisionAvoidanceFactor")
    public Double getRedeliveryCollisionAvoidanceFactor() {
        return this.redeliveryCollisionAvoidanceFactor;
    }

    @JsonProperty(value="redeliveryCollisionAvoidanceFactor")
    public void setRedeliveryCollisionAvoidanceFactor(Double redeliveryCollisionAvoidanceFactor) {
        this.redeliveryCollisionAvoidanceFactor = redeliveryCollisionAvoidanceFactor;
    }

    public AddressSetting withRedeliveryCollisionAvoidanceFactor(Double redeliveryCollisionAvoidanceFactor) {
        this.redeliveryCollisionAvoidanceFactor = redeliveryCollisionAvoidanceFactor;
        return this;
    }

    @JsonProperty(value="maxRedeliveryDelay")
    public Integer getMaxRedeliveryDelay() {
        return this.maxRedeliveryDelay;
    }

    @JsonProperty(value="maxRedeliveryDelay")
    public void setMaxRedeliveryDelay(Integer maxRedeliveryDelay) {
        this.maxRedeliveryDelay = maxRedeliveryDelay;
    }

    public AddressSetting withMaxRedeliveryDelay(Integer maxRedeliveryDelay) {
        this.maxRedeliveryDelay = maxRedeliveryDelay;
        return this;
    }

    @JsonProperty(value="maxDeliveryAttempts")
    public Integer getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts;
    }

    @JsonProperty(value="maxDeliveryAttempts")
    public void setMaxDeliveryAttempts(Integer maxDeliveryAttempts) {
        this.maxDeliveryAttempts = maxDeliveryAttempts;
    }

    public AddressSetting withMaxDeliveryAttempts(Integer maxDeliveryAttempts) {
        this.maxDeliveryAttempts = maxDeliveryAttempts;
        return this;
    }

    @JsonProperty(value="maxSizeBytes")
    public String getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    @JsonProperty(value="maxSizeBytes")
    public void setMaxSizeBytes(String maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
    }

    public AddressSetting withMaxSizeBytes(String maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    @JsonProperty(value="maxSizeBytesRejectThreshold")
    public Integer getMaxSizeBytesRejectThreshold() {
        return this.maxSizeBytesRejectThreshold;
    }

    @JsonProperty(value="maxSizeBytesRejectThreshold")
    public void setMaxSizeBytesRejectThreshold(Integer maxSizeBytesRejectThreshold) {
        this.maxSizeBytesRejectThreshold = maxSizeBytesRejectThreshold;
    }

    public AddressSetting withMaxSizeBytesRejectThreshold(Integer maxSizeBytesRejectThreshold) {
        this.maxSizeBytesRejectThreshold = maxSizeBytesRejectThreshold;
        return this;
    }

    @JsonProperty(value="pageSizeBytes")
    public String getPageSizeBytes() {
        return this.pageSizeBytes;
    }

    @JsonProperty(value="pageSizeBytes")
    public void setPageSizeBytes(String pageSizeBytes) {
        this.pageSizeBytes = pageSizeBytes;
    }

    public AddressSetting withPageSizeBytes(String pageSizeBytes) {
        this.pageSizeBytes = pageSizeBytes;
        return this;
    }

    @JsonProperty(value="pageMaxCacheSize")
    public Integer getPageMaxCacheSize() {
        return this.pageMaxCacheSize;
    }

    @JsonProperty(value="pageMaxCacheSize")
    public void setPageMaxCacheSize(Integer pageMaxCacheSize) {
        this.pageMaxCacheSize = pageMaxCacheSize;
    }

    public AddressSetting withPageMaxCacheSize(Integer pageMaxCacheSize) {
        this.pageMaxCacheSize = pageMaxCacheSize;
        return this;
    }

    @JsonProperty(value="addressFullPolicy")
    public AddressFullPolicy getAddressFullPolicy() {
        return this.addressFullPolicy;
    }

    @JsonProperty(value="addressFullPolicy")
    public void setAddressFullPolicy(AddressFullPolicy addressFullPolicy) {
        this.addressFullPolicy = addressFullPolicy;
    }

    public AddressSetting withAddressFullPolicy(AddressFullPolicy addressFullPolicy) {
        this.addressFullPolicy = addressFullPolicy;
        return this;
    }

    @JsonProperty(value="messageCounterHistoryDayLimit")
    public Integer getMessageCounterHistoryDayLimit() {
        return this.messageCounterHistoryDayLimit;
    }

    @JsonProperty(value="messageCounterHistoryDayLimit")
    public void setMessageCounterHistoryDayLimit(Integer messageCounterHistoryDayLimit) {
        this.messageCounterHistoryDayLimit = messageCounterHistoryDayLimit;
    }

    public AddressSetting withMessageCounterHistoryDayLimit(Integer messageCounterHistoryDayLimit) {
        this.messageCounterHistoryDayLimit = messageCounterHistoryDayLimit;
        return this;
    }

    @JsonProperty(value="lastValueQueue")
    public Boolean getLastValueQueue() {
        return this.lastValueQueue;
    }

    @JsonProperty(value="lastValueQueue")
    public void setLastValueQueue(Boolean lastValueQueue) {
        this.lastValueQueue = lastValueQueue;
    }

    public AddressSetting withLastValueQueue(Boolean lastValueQueue) {
        this.lastValueQueue = lastValueQueue;
        return this;
    }

    @JsonProperty(value="defaultLastValueQueue")
    public Boolean getDefaultLastValueQueue() {
        return this.defaultLastValueQueue;
    }

    @JsonProperty(value="defaultLastValueQueue")
    public void setDefaultLastValueQueue(Boolean defaultLastValueQueue) {
        this.defaultLastValueQueue = defaultLastValueQueue;
    }

    public AddressSetting withDefaultLastValueQueue(Boolean defaultLastValueQueue) {
        this.defaultLastValueQueue = defaultLastValueQueue;
        return this;
    }

    @JsonProperty(value="defaultLastValueKey")
    public String getDefaultLastValueKey() {
        return this.defaultLastValueKey;
    }

    @JsonProperty(value="defaultLastValueKey")
    public void setDefaultLastValueKey(String defaultLastValueKey) {
        this.defaultLastValueKey = defaultLastValueKey;
    }

    public AddressSetting withDefaultLastValueKey(String defaultLastValueKey) {
        this.defaultLastValueKey = defaultLastValueKey;
        return this;
    }

    @JsonProperty(value="defaultNonDestructive")
    public Boolean getDefaultNonDestructive() {
        return this.defaultNonDestructive;
    }

    @JsonProperty(value="defaultNonDestructive")
    public void setDefaultNonDestructive(Boolean defaultNonDestructive) {
        this.defaultNonDestructive = defaultNonDestructive;
    }

    public AddressSetting withDefaultNonDestructive(Boolean defaultNonDestructive) {
        this.defaultNonDestructive = defaultNonDestructive;
        return this;
    }

    @JsonProperty(value="defaultExclusiveQueue")
    public Boolean getDefaultExclusiveQueue() {
        return this.defaultExclusiveQueue;
    }

    @JsonProperty(value="defaultExclusiveQueue")
    public void setDefaultExclusiveQueue(Boolean defaultExclusiveQueue) {
        this.defaultExclusiveQueue = defaultExclusiveQueue;
    }

    public AddressSetting withDefaultExclusiveQueue(Boolean defaultExclusiveQueue) {
        this.defaultExclusiveQueue = defaultExclusiveQueue;
        return this;
    }

    @JsonProperty(value="defaultGroupRebalance")
    public Boolean getDefaultGroupRebalance() {
        return this.defaultGroupRebalance;
    }

    @JsonProperty(value="defaultGroupRebalance")
    public void setDefaultGroupRebalance(Boolean defaultGroupRebalance) {
        this.defaultGroupRebalance = defaultGroupRebalance;
    }

    public AddressSetting withDefaultGroupRebalance(Boolean defaultGroupRebalance) {
        this.defaultGroupRebalance = defaultGroupRebalance;
        return this;
    }

    @JsonProperty(value="defaultGroupRebalancePauseDispatch")
    public Boolean getDefaultGroupRebalancePauseDispatch() {
        return this.defaultGroupRebalancePauseDispatch;
    }

    @JsonProperty(value="defaultGroupRebalancePauseDispatch")
    public void setDefaultGroupRebalancePauseDispatch(Boolean defaultGroupRebalancePauseDispatch) {
        this.defaultGroupRebalancePauseDispatch = defaultGroupRebalancePauseDispatch;
    }

    public AddressSetting withDefaultGroupRebalancePauseDispatch(Boolean defaultGroupRebalancePauseDispatch) {
        this.defaultGroupRebalancePauseDispatch = defaultGroupRebalancePauseDispatch;
        return this;
    }

    @JsonProperty(value="defaultGroupBuckets")
    public Integer getDefaultGroupBuckets() {
        return this.defaultGroupBuckets;
    }

    @JsonProperty(value="defaultGroupBuckets")
    public void setDefaultGroupBuckets(Integer defaultGroupBuckets) {
        this.defaultGroupBuckets = defaultGroupBuckets;
    }

    public AddressSetting withDefaultGroupBuckets(Integer defaultGroupBuckets) {
        this.defaultGroupBuckets = defaultGroupBuckets;
        return this;
    }

    @JsonProperty(value="defaultGroupFirstKey")
    public String getDefaultGroupFirstKey() {
        return this.defaultGroupFirstKey;
    }

    @JsonProperty(value="defaultGroupFirstKey")
    public void setDefaultGroupFirstKey(String defaultGroupFirstKey) {
        this.defaultGroupFirstKey = defaultGroupFirstKey;
    }

    public AddressSetting withDefaultGroupFirstKey(String defaultGroupFirstKey) {
        this.defaultGroupFirstKey = defaultGroupFirstKey;
        return this;
    }

    @JsonProperty(value="defaultConsumersBeforeDispatch")
    public Integer getDefaultConsumersBeforeDispatch() {
        return this.defaultConsumersBeforeDispatch;
    }

    @JsonProperty(value="defaultConsumersBeforeDispatch")
    public void setDefaultConsumersBeforeDispatch(Integer defaultConsumersBeforeDispatch) {
        this.defaultConsumersBeforeDispatch = defaultConsumersBeforeDispatch;
    }

    public AddressSetting withDefaultConsumersBeforeDispatch(Integer defaultConsumersBeforeDispatch) {
        this.defaultConsumersBeforeDispatch = defaultConsumersBeforeDispatch;
        return this;
    }

    @JsonProperty(value="defaultDelayBeforeDispatch")
    public Integer getDefaultDelayBeforeDispatch() {
        return this.defaultDelayBeforeDispatch;
    }

    @JsonProperty(value="defaultDelayBeforeDispatch")
    public void setDefaultDelayBeforeDispatch(Integer defaultDelayBeforeDispatch) {
        this.defaultDelayBeforeDispatch = defaultDelayBeforeDispatch;
    }

    public AddressSetting withDefaultDelayBeforeDispatch(Integer defaultDelayBeforeDispatch) {
        this.defaultDelayBeforeDispatch = defaultDelayBeforeDispatch;
        return this;
    }

    @JsonProperty(value="redistributionDelay")
    public Integer getRedistributionDelay() {
        return this.redistributionDelay;
    }

    @JsonProperty(value="redistributionDelay")
    public void setRedistributionDelay(Integer redistributionDelay) {
        this.redistributionDelay = redistributionDelay;
    }

    public AddressSetting withRedistributionDelay(Integer redistributionDelay) {
        this.redistributionDelay = redistributionDelay;
        return this;
    }

    @JsonProperty(value="sendToDlaOnNoRoute")
    public Boolean getSendToDlaOnNoRoute() {
        return this.sendToDlaOnNoRoute;
    }

    @JsonProperty(value="sendToDlaOnNoRoute")
    public void setSendToDlaOnNoRoute(Boolean sendToDlaOnNoRoute) {
        this.sendToDlaOnNoRoute = sendToDlaOnNoRoute;
    }

    public AddressSetting withSendToDlaOnNoRoute(Boolean sendToDlaOnNoRoute) {
        this.sendToDlaOnNoRoute = sendToDlaOnNoRoute;
        return this;
    }

    @JsonProperty(value="slowConsumerThreshold")
    public Integer getSlowConsumerThreshold() {
        return this.slowConsumerThreshold;
    }

    @JsonProperty(value="slowConsumerThreshold")
    public void setSlowConsumerThreshold(Integer slowConsumerThreshold) {
        this.slowConsumerThreshold = slowConsumerThreshold;
    }

    public AddressSetting withSlowConsumerThreshold(Integer slowConsumerThreshold) {
        this.slowConsumerThreshold = slowConsumerThreshold;
        return this;
    }

    @JsonProperty(value="slowConsumerPolicy")
    public SlowConsumerPolicy getSlowConsumerPolicy() {
        return this.slowConsumerPolicy;
    }

    @JsonProperty(value="slowConsumerPolicy")
    public void setSlowConsumerPolicy(SlowConsumerPolicy slowConsumerPolicy) {
        this.slowConsumerPolicy = slowConsumerPolicy;
    }

    public AddressSetting withSlowConsumerPolicy(SlowConsumerPolicy slowConsumerPolicy) {
        this.slowConsumerPolicy = slowConsumerPolicy;
        return this;
    }

    @JsonProperty(value="slowConsumerCheckPeriod")
    public Integer getSlowConsumerCheckPeriod() {
        return this.slowConsumerCheckPeriod;
    }

    @JsonProperty(value="slowConsumerCheckPeriod")
    public void setSlowConsumerCheckPeriod(Integer slowConsumerCheckPeriod) {
        this.slowConsumerCheckPeriod = slowConsumerCheckPeriod;
    }

    public AddressSetting withSlowConsumerCheckPeriod(Integer slowConsumerCheckPeriod) {
        this.slowConsumerCheckPeriod = slowConsumerCheckPeriod;
        return this;
    }

    @JsonProperty(value="autoCreateJmsQueues")
    public Boolean getAutoCreateJmsQueues() {
        return this.autoCreateJmsQueues;
    }

    @JsonProperty(value="autoCreateJmsQueues")
    public void setAutoCreateJmsQueues(Boolean autoCreateJmsQueues) {
        this.autoCreateJmsQueues = autoCreateJmsQueues;
    }

    public AddressSetting withAutoCreateJmsQueues(Boolean autoCreateJmsQueues) {
        this.autoCreateJmsQueues = autoCreateJmsQueues;
        return this;
    }

    @JsonProperty(value="autoDeleteJmsQueues")
    public Boolean getAutoDeleteJmsQueues() {
        return this.autoDeleteJmsQueues;
    }

    @JsonProperty(value="autoDeleteJmsQueues")
    public void setAutoDeleteJmsQueues(Boolean autoDeleteJmsQueues) {
        this.autoDeleteJmsQueues = autoDeleteJmsQueues;
    }

    public AddressSetting withAutoDeleteJmsQueues(Boolean autoDeleteJmsQueues) {
        this.autoDeleteJmsQueues = autoDeleteJmsQueues;
        return this;
    }

    @JsonProperty(value="autoCreateJmsTopics")
    public Boolean getAutoCreateJmsTopics() {
        return this.autoCreateJmsTopics;
    }

    @JsonProperty(value="autoCreateJmsTopics")
    public void setAutoCreateJmsTopics(Boolean autoCreateJmsTopics) {
        this.autoCreateJmsTopics = autoCreateJmsTopics;
    }

    public AddressSetting withAutoCreateJmsTopics(Boolean autoCreateJmsTopics) {
        this.autoCreateJmsTopics = autoCreateJmsTopics;
        return this;
    }

    @JsonProperty(value="autoDeleteJmsTopics")
    public Boolean getAutoDeleteJmsTopics() {
        return this.autoDeleteJmsTopics;
    }

    @JsonProperty(value="autoDeleteJmsTopics")
    public void setAutoDeleteJmsTopics(Boolean autoDeleteJmsTopics) {
        this.autoDeleteJmsTopics = autoDeleteJmsTopics;
    }

    public AddressSetting withAutoDeleteJmsTopics(Boolean autoDeleteJmsTopics) {
        this.autoDeleteJmsTopics = autoDeleteJmsTopics;
        return this;
    }

    @JsonProperty(value="autoCreateQueues")
    public Boolean getAutoCreateQueues() {
        return this.autoCreateQueues;
    }

    @JsonProperty(value="autoCreateQueues")
    public void setAutoCreateQueues(Boolean autoCreateQueues) {
        this.autoCreateQueues = autoCreateQueues;
    }

    public AddressSetting withAutoCreateQueues(Boolean autoCreateQueues) {
        this.autoCreateQueues = autoCreateQueues;
        return this;
    }

    @JsonProperty(value="autoDeleteQueues")
    public Boolean getAutoDeleteQueues() {
        return this.autoDeleteQueues;
    }

    @JsonProperty(value="autoDeleteQueues")
    public void setAutoDeleteQueues(Boolean autoDeleteQueues) {
        this.autoDeleteQueues = autoDeleteQueues;
    }

    public AddressSetting withAutoDeleteQueues(Boolean autoDeleteQueues) {
        this.autoDeleteQueues = autoDeleteQueues;
        return this;
    }

    @JsonProperty(value="autoDeleteCreatedQueues")
    public Boolean getAutoDeleteCreatedQueues() {
        return this.autoDeleteCreatedQueues;
    }

    @JsonProperty(value="autoDeleteCreatedQueues")
    public void setAutoDeleteCreatedQueues(Boolean autoDeleteCreatedQueues) {
        this.autoDeleteCreatedQueues = autoDeleteCreatedQueues;
    }

    public AddressSetting withAutoDeleteCreatedQueues(Boolean autoDeleteCreatedQueues) {
        this.autoDeleteCreatedQueues = autoDeleteCreatedQueues;
        return this;
    }

    @JsonProperty(value="autoDeleteQueuesDelay")
    public Integer getAutoDeleteQueuesDelay() {
        return this.autoDeleteQueuesDelay;
    }

    @JsonProperty(value="autoDeleteQueuesDelay")
    public void setAutoDeleteQueuesDelay(Integer autoDeleteQueuesDelay) {
        this.autoDeleteQueuesDelay = autoDeleteQueuesDelay;
    }

    public AddressSetting withAutoDeleteQueuesDelay(Integer autoDeleteQueuesDelay) {
        this.autoDeleteQueuesDelay = autoDeleteQueuesDelay;
        return this;
    }

    @JsonProperty(value="autoDeleteQueuesMessageCount")
    public Integer getAutoDeleteQueuesMessageCount() {
        return this.autoDeleteQueuesMessageCount;
    }

    @JsonProperty(value="autoDeleteQueuesMessageCount")
    public void setAutoDeleteQueuesMessageCount(Integer autoDeleteQueuesMessageCount) {
        this.autoDeleteQueuesMessageCount = autoDeleteQueuesMessageCount;
    }

    public AddressSetting withAutoDeleteQueuesMessageCount(Integer autoDeleteQueuesMessageCount) {
        this.autoDeleteQueuesMessageCount = autoDeleteQueuesMessageCount;
        return this;
    }

    @JsonProperty(value="configDeleteQueues")
    public ConfigDeleteQueues getConfigDeleteQueues() {
        return this.configDeleteQueues;
    }

    @JsonProperty(value="configDeleteQueues")
    public void setConfigDeleteQueues(ConfigDeleteQueues configDeleteQueues) {
        this.configDeleteQueues = configDeleteQueues;
    }

    public AddressSetting withConfigDeleteQueues(ConfigDeleteQueues configDeleteQueues) {
        this.configDeleteQueues = configDeleteQueues;
        return this;
    }

    @JsonProperty(value="autoCreateAddresses")
    public Boolean getAutoCreateAddresses() {
        return this.autoCreateAddresses;
    }

    @JsonProperty(value="autoCreateAddresses")
    public void setAutoCreateAddresses(Boolean autoCreateAddresses) {
        this.autoCreateAddresses = autoCreateAddresses;
    }

    public AddressSetting withAutoCreateAddresses(Boolean autoCreateAddresses) {
        this.autoCreateAddresses = autoCreateAddresses;
        return this;
    }

    @JsonProperty(value="autoDeleteAddresses")
    public Boolean getAutoDeleteAddresses() {
        return this.autoDeleteAddresses;
    }

    @JsonProperty(value="autoDeleteAddresses")
    public void setAutoDeleteAddresses(Boolean autoDeleteAddresses) {
        this.autoDeleteAddresses = autoDeleteAddresses;
    }

    public AddressSetting withAutoDeleteAddresses(Boolean autoDeleteAddresses) {
        this.autoDeleteAddresses = autoDeleteAddresses;
        return this;
    }

    @JsonProperty(value="autoDeleteAddressesDelay")
    public Integer getAutoDeleteAddressesDelay() {
        return this.autoDeleteAddressesDelay;
    }

    @JsonProperty(value="autoDeleteAddressesDelay")
    public void setAutoDeleteAddressesDelay(Integer autoDeleteAddressesDelay) {
        this.autoDeleteAddressesDelay = autoDeleteAddressesDelay;
    }

    public AddressSetting withAutoDeleteAddressesDelay(Integer autoDeleteAddressesDelay) {
        this.autoDeleteAddressesDelay = autoDeleteAddressesDelay;
        return this;
    }

    @JsonProperty(value="configDeleteAddresses")
    public ConfigDeleteAddresses getConfigDeleteAddresses() {
        return this.configDeleteAddresses;
    }

    @JsonProperty(value="configDeleteAddresses")
    public void setConfigDeleteAddresses(ConfigDeleteAddresses configDeleteAddresses) {
        this.configDeleteAddresses = configDeleteAddresses;
    }

    public AddressSetting withConfigDeleteAddresses(ConfigDeleteAddresses configDeleteAddresses) {
        this.configDeleteAddresses = configDeleteAddresses;
        return this;
    }

    @JsonProperty(value="managementBrowsePageSize")
    public Integer getManagementBrowsePageSize() {
        return this.managementBrowsePageSize;
    }

    @JsonProperty(value="managementBrowsePageSize")
    public void setManagementBrowsePageSize(Integer managementBrowsePageSize) {
        this.managementBrowsePageSize = managementBrowsePageSize;
    }

    public AddressSetting withManagementBrowsePageSize(Integer managementBrowsePageSize) {
        this.managementBrowsePageSize = managementBrowsePageSize;
        return this;
    }

    @JsonProperty(value="defaultPurgeOnNoConsumers")
    public Boolean getDefaultPurgeOnNoConsumers() {
        return this.defaultPurgeOnNoConsumers;
    }

    @JsonProperty(value="defaultPurgeOnNoConsumers")
    public void setDefaultPurgeOnNoConsumers(Boolean defaultPurgeOnNoConsumers) {
        this.defaultPurgeOnNoConsumers = defaultPurgeOnNoConsumers;
    }

    public AddressSetting withDefaultPurgeOnNoConsumers(Boolean defaultPurgeOnNoConsumers) {
        this.defaultPurgeOnNoConsumers = defaultPurgeOnNoConsumers;
        return this;
    }

    @JsonProperty(value="defaultMaxConsumers")
    public Integer getDefaultMaxConsumers() {
        return this.defaultMaxConsumers;
    }

    @JsonProperty(value="defaultMaxConsumers")
    public void setDefaultMaxConsumers(Integer defaultMaxConsumers) {
        this.defaultMaxConsumers = defaultMaxConsumers;
    }

    public AddressSetting withDefaultMaxConsumers(Integer defaultMaxConsumers) {
        this.defaultMaxConsumers = defaultMaxConsumers;
        return this;
    }

    @JsonProperty(value="defaultQueueRoutingType")
    public DefaultQueueRoutingType getDefaultQueueRoutingType() {
        return this.defaultQueueRoutingType;
    }

    @JsonProperty(value="defaultQueueRoutingType")
    public void setDefaultQueueRoutingType(DefaultQueueRoutingType defaultQueueRoutingType) {
        this.defaultQueueRoutingType = defaultQueueRoutingType;
    }

    public AddressSetting withDefaultQueueRoutingType(DefaultQueueRoutingType defaultQueueRoutingType) {
        this.defaultQueueRoutingType = defaultQueueRoutingType;
        return this;
    }

    @JsonProperty(value="defaultAddressRoutingType")
    public DefaultAddressRoutingType getDefaultAddressRoutingType() {
        return this.defaultAddressRoutingType;
    }

    @JsonProperty(value="defaultAddressRoutingType")
    public void setDefaultAddressRoutingType(DefaultAddressRoutingType defaultAddressRoutingType) {
        this.defaultAddressRoutingType = defaultAddressRoutingType;
    }

    public AddressSetting withDefaultAddressRoutingType(DefaultAddressRoutingType defaultAddressRoutingType) {
        this.defaultAddressRoutingType = defaultAddressRoutingType;
        return this;
    }

    @JsonProperty(value="defaultConsumerWindowSize")
    public Integer getDefaultConsumerWindowSize() {
        return this.defaultConsumerWindowSize;
    }

    @JsonProperty(value="defaultConsumerWindowSize")
    public void setDefaultConsumerWindowSize(Integer defaultConsumerWindowSize) {
        this.defaultConsumerWindowSize = defaultConsumerWindowSize;
    }

    public AddressSetting withDefaultConsumerWindowSize(Integer defaultConsumerWindowSize) {
        this.defaultConsumerWindowSize = defaultConsumerWindowSize;
        return this;
    }

    @JsonProperty(value="defaultRingSize")
    public Integer getDefaultRingSize() {
        return this.defaultRingSize;
    }

    @JsonProperty(value="defaultRingSize")
    public void setDefaultRingSize(Integer defaultRingSize) {
        this.defaultRingSize = defaultRingSize;
    }

    public AddressSetting withDefaultRingSize(Integer defaultRingSize) {
        this.defaultRingSize = defaultRingSize;
        return this;
    }

    @JsonProperty(value="retroactiveMessageCount")
    public Integer getRetroactiveMessageCount() {
        return this.retroactiveMessageCount;
    }

    @JsonProperty(value="retroactiveMessageCount")
    public void setRetroactiveMessageCount(Integer retroactiveMessageCount) {
        this.retroactiveMessageCount = retroactiveMessageCount;
    }

    public AddressSetting withRetroactiveMessageCount(Integer retroactiveMessageCount) {
        this.retroactiveMessageCount = retroactiveMessageCount;
        return this;
    }

    @JsonProperty(value="enableMetrics")
    public Boolean getEnableMetrics() {
        return this.enableMetrics;
    }

    @JsonProperty(value="enableMetrics")
    public void setEnableMetrics(Boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
    }

    public AddressSetting withEnableMetrics(Boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
        return this;
    }

    @JsonProperty(value="match")
    public String getMatch() {
        return this.match;
    }

    @JsonProperty(value="match")
    public void setMatch(String match) {
        this.match = match;
    }

    public AddressSetting withMatch(String match) {
        this.match = match;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public AddressSetting withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AddressSetting.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("deadLetterAddress");
        sb.append('=');
        sb.append(this.deadLetterAddress == null ? "<null>" : this.deadLetterAddress);
        sb.append(',');
        sb.append("autoCreateDeadLetterResources");
        sb.append('=');
        sb.append(this.autoCreateDeadLetterResources == null ? "<null>" : this.autoCreateDeadLetterResources);
        sb.append(',');
        sb.append("deadLetterQueuePrefix");
        sb.append('=');
        sb.append(this.deadLetterQueuePrefix == null ? "<null>" : this.deadLetterQueuePrefix);
        sb.append(',');
        sb.append("deadLetterQueueSuffix");
        sb.append('=');
        sb.append(this.deadLetterQueueSuffix == null ? "<null>" : this.deadLetterQueueSuffix);
        sb.append(',');
        sb.append("expiryAddress");
        sb.append('=');
        sb.append(this.expiryAddress == null ? "<null>" : this.expiryAddress);
        sb.append(',');
        sb.append("autoCreateExpiryResources");
        sb.append('=');
        sb.append(this.autoCreateExpiryResources == null ? "<null>" : this.autoCreateExpiryResources);
        sb.append(',');
        sb.append("expiryQueuePrefix");
        sb.append('=');
        sb.append(this.expiryQueuePrefix == null ? "<null>" : this.expiryQueuePrefix);
        sb.append(',');
        sb.append("expiryQueueSuffix");
        sb.append('=');
        sb.append(this.expiryQueueSuffix == null ? "<null>" : this.expiryQueueSuffix);
        sb.append(',');
        sb.append("expiryDelay");
        sb.append('=');
        sb.append(this.expiryDelay == null ? "<null>" : this.expiryDelay);
        sb.append(',');
        sb.append("minExpiryDelay");
        sb.append('=');
        sb.append(this.minExpiryDelay == null ? "<null>" : this.minExpiryDelay);
        sb.append(',');
        sb.append("maxExpiryDelay");
        sb.append('=');
        sb.append(this.maxExpiryDelay == null ? "<null>" : this.maxExpiryDelay);
        sb.append(',');
        sb.append("redeliveryDelay");
        sb.append('=');
        sb.append(this.redeliveryDelay == null ? "<null>" : this.redeliveryDelay);
        sb.append(',');
        sb.append("redeliveryDelayMultiplier");
        sb.append('=');
        sb.append(this.redeliveryDelayMultiplier == null ? "<null>" : this.redeliveryDelayMultiplier);
        sb.append(',');
        sb.append("redeliveryCollisionAvoidanceFactor");
        sb.append('=');
        sb.append(this.redeliveryCollisionAvoidanceFactor == null ? "<null>" : this.redeliveryCollisionAvoidanceFactor);
        sb.append(',');
        sb.append("maxRedeliveryDelay");
        sb.append('=');
        sb.append(this.maxRedeliveryDelay == null ? "<null>" : this.maxRedeliveryDelay);
        sb.append(',');
        sb.append("maxDeliveryAttempts");
        sb.append('=');
        sb.append(this.maxDeliveryAttempts == null ? "<null>" : this.maxDeliveryAttempts);
        sb.append(',');
        sb.append("maxSizeBytes");
        sb.append('=');
        sb.append(this.maxSizeBytes == null ? "<null>" : this.maxSizeBytes);
        sb.append(',');
        sb.append("maxSizeBytesRejectThreshold");
        sb.append('=');
        sb.append(this.maxSizeBytesRejectThreshold == null ? "<null>" : this.maxSizeBytesRejectThreshold);
        sb.append(',');
        sb.append("pageSizeBytes");
        sb.append('=');
        sb.append(this.pageSizeBytes == null ? "<null>" : this.pageSizeBytes);
        sb.append(',');
        sb.append("pageMaxCacheSize");
        sb.append('=');
        sb.append(this.pageMaxCacheSize == null ? "<null>" : this.pageMaxCacheSize);
        sb.append(',');
        sb.append("addressFullPolicy");
        sb.append('=');
        sb.append(this.addressFullPolicy == null ? "<null>" : this.addressFullPolicy);
        sb.append(',');
        sb.append("messageCounterHistoryDayLimit");
        sb.append('=');
        sb.append(this.messageCounterHistoryDayLimit == null ? "<null>" : this.messageCounterHistoryDayLimit);
        sb.append(',');
        sb.append("lastValueQueue");
        sb.append('=');
        sb.append(this.lastValueQueue == null ? "<null>" : this.lastValueQueue);
        sb.append(',');
        sb.append("defaultLastValueQueue");
        sb.append('=');
        sb.append(this.defaultLastValueQueue == null ? "<null>" : this.defaultLastValueQueue);
        sb.append(',');
        sb.append("defaultLastValueKey");
        sb.append('=');
        sb.append(this.defaultLastValueKey == null ? "<null>" : this.defaultLastValueKey);
        sb.append(',');
        sb.append("defaultNonDestructive");
        sb.append('=');
        sb.append(this.defaultNonDestructive == null ? "<null>" : this.defaultNonDestructive);
        sb.append(',');
        sb.append("defaultExclusiveQueue");
        sb.append('=');
        sb.append(this.defaultExclusiveQueue == null ? "<null>" : this.defaultExclusiveQueue);
        sb.append(',');
        sb.append("defaultGroupRebalance");
        sb.append('=');
        sb.append(this.defaultGroupRebalance == null ? "<null>" : this.defaultGroupRebalance);
        sb.append(',');
        sb.append("defaultGroupRebalancePauseDispatch");
        sb.append('=');
        sb.append(this.defaultGroupRebalancePauseDispatch == null ? "<null>" : this.defaultGroupRebalancePauseDispatch);
        sb.append(',');
        sb.append("defaultGroupBuckets");
        sb.append('=');
        sb.append(this.defaultGroupBuckets == null ? "<null>" : this.defaultGroupBuckets);
        sb.append(',');
        sb.append("defaultGroupFirstKey");
        sb.append('=');
        sb.append(this.defaultGroupFirstKey == null ? "<null>" : this.defaultGroupFirstKey);
        sb.append(',');
        sb.append("defaultConsumersBeforeDispatch");
        sb.append('=');
        sb.append(this.defaultConsumersBeforeDispatch == null ? "<null>" : this.defaultConsumersBeforeDispatch);
        sb.append(',');
        sb.append("defaultDelayBeforeDispatch");
        sb.append('=');
        sb.append(this.defaultDelayBeforeDispatch == null ? "<null>" : this.defaultDelayBeforeDispatch);
        sb.append(',');
        sb.append("redistributionDelay");
        sb.append('=');
        sb.append(this.redistributionDelay == null ? "<null>" : this.redistributionDelay);
        sb.append(',');
        sb.append("sendToDlaOnNoRoute");
        sb.append('=');
        sb.append(this.sendToDlaOnNoRoute == null ? "<null>" : this.sendToDlaOnNoRoute);
        sb.append(',');
        sb.append("slowConsumerThreshold");
        sb.append('=');
        sb.append(this.slowConsumerThreshold == null ? "<null>" : this.slowConsumerThreshold);
        sb.append(',');
        sb.append("slowConsumerPolicy");
        sb.append('=');
        sb.append(this.slowConsumerPolicy == null ? "<null>" : this.slowConsumerPolicy);
        sb.append(',');
        sb.append("slowConsumerCheckPeriod");
        sb.append('=');
        sb.append(this.slowConsumerCheckPeriod == null ? "<null>" : this.slowConsumerCheckPeriod);
        sb.append(',');
        sb.append("autoCreateJmsQueues");
        sb.append('=');
        sb.append(this.autoCreateJmsQueues == null ? "<null>" : this.autoCreateJmsQueues);
        sb.append(',');
        sb.append("autoDeleteJmsQueues");
        sb.append('=');
        sb.append(this.autoDeleteJmsQueues == null ? "<null>" : this.autoDeleteJmsQueues);
        sb.append(',');
        sb.append("autoCreateJmsTopics");
        sb.append('=');
        sb.append(this.autoCreateJmsTopics == null ? "<null>" : this.autoCreateJmsTopics);
        sb.append(',');
        sb.append("autoDeleteJmsTopics");
        sb.append('=');
        sb.append(this.autoDeleteJmsTopics == null ? "<null>" : this.autoDeleteJmsTopics);
        sb.append(',');
        sb.append("autoCreateQueues");
        sb.append('=');
        sb.append(this.autoCreateQueues == null ? "<null>" : this.autoCreateQueues);
        sb.append(',');
        sb.append("autoDeleteQueues");
        sb.append('=');
        sb.append(this.autoDeleteQueues == null ? "<null>" : this.autoDeleteQueues);
        sb.append(',');
        sb.append("autoDeleteCreatedQueues");
        sb.append('=');
        sb.append(this.autoDeleteCreatedQueues == null ? "<null>" : this.autoDeleteCreatedQueues);
        sb.append(',');
        sb.append("autoDeleteQueuesDelay");
        sb.append('=');
        sb.append(this.autoDeleteQueuesDelay == null ? "<null>" : this.autoDeleteQueuesDelay);
        sb.append(',');
        sb.append("autoDeleteQueuesMessageCount");
        sb.append('=');
        sb.append(this.autoDeleteQueuesMessageCount == null ? "<null>" : this.autoDeleteQueuesMessageCount);
        sb.append(',');
        sb.append("configDeleteQueues");
        sb.append('=');
        sb.append(this.configDeleteQueues == null ? "<null>" : this.configDeleteQueues);
        sb.append(',');
        sb.append("autoCreateAddresses");
        sb.append('=');
        sb.append(this.autoCreateAddresses == null ? "<null>" : this.autoCreateAddresses);
        sb.append(',');
        sb.append("autoDeleteAddresses");
        sb.append('=');
        sb.append(this.autoDeleteAddresses == null ? "<null>" : this.autoDeleteAddresses);
        sb.append(',');
        sb.append("autoDeleteAddressesDelay");
        sb.append('=');
        sb.append(this.autoDeleteAddressesDelay == null ? "<null>" : this.autoDeleteAddressesDelay);
        sb.append(',');
        sb.append("configDeleteAddresses");
        sb.append('=');
        sb.append(this.configDeleteAddresses == null ? "<null>" : this.configDeleteAddresses);
        sb.append(',');
        sb.append("managementBrowsePageSize");
        sb.append('=');
        sb.append(this.managementBrowsePageSize == null ? "<null>" : this.managementBrowsePageSize);
        sb.append(',');
        sb.append("defaultPurgeOnNoConsumers");
        sb.append('=');
        sb.append(this.defaultPurgeOnNoConsumers == null ? "<null>" : this.defaultPurgeOnNoConsumers);
        sb.append(',');
        sb.append("defaultMaxConsumers");
        sb.append('=');
        sb.append(this.defaultMaxConsumers == null ? "<null>" : this.defaultMaxConsumers);
        sb.append(',');
        sb.append("defaultQueueRoutingType");
        sb.append('=');
        sb.append(this.defaultQueueRoutingType == null ? "<null>" : this.defaultQueueRoutingType);
        sb.append(',');
        sb.append("defaultAddressRoutingType");
        sb.append('=');
        sb.append(this.defaultAddressRoutingType == null ? "<null>" : this.defaultAddressRoutingType);
        sb.append(',');
        sb.append("defaultConsumerWindowSize");
        sb.append('=');
        sb.append(this.defaultConsumerWindowSize == null ? "<null>" : this.defaultConsumerWindowSize);
        sb.append(',');
        sb.append("defaultRingSize");
        sb.append('=');
        sb.append(this.defaultRingSize == null ? "<null>" : this.defaultRingSize);
        sb.append(',');
        sb.append("retroactiveMessageCount");
        sb.append('=');
        sb.append(this.retroactiveMessageCount == null ? "<null>" : this.retroactiveMessageCount);
        sb.append(',');
        sb.append("enableMetrics");
        sb.append('=');
        sb.append(this.enableMetrics == null ? "<null>" : this.enableMetrics);
        sb.append(',');
        sb.append("match");
        sb.append('=');
        sb.append(this.match == null ? "<null>" : this.match);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.expiryQueuePrefix == null ? 0 : this.expiryQueuePrefix.hashCode());
        result = result * 31 + (this.defaultConsumerWindowSize == null ? 0 : this.defaultConsumerWindowSize.hashCode());
        result = result * 31 + (this.deadLetterQueuePrefix == null ? 0 : this.deadLetterQueuePrefix.hashCode());
        result = result * 31 + (this.defaultGroupRebalancePauseDispatch == null ? 0 : this.defaultGroupRebalancePauseDispatch.hashCode());
        result = result * 31 + (this.autoCreateAddresses == null ? 0 : this.autoCreateAddresses.hashCode());
        result = result * 31 + (this.defaultGroupBuckets == null ? 0 : this.defaultGroupBuckets.hashCode());
        result = result * 31 + (this.slowConsumerThreshold == null ? 0 : this.slowConsumerThreshold.hashCode());
        result = result * 31 + (this.autoCreateExpiryResources == null ? 0 : this.autoCreateExpiryResources.hashCode());
        result = result * 31 + (this.pageSizeBytes == null ? 0 : this.pageSizeBytes.hashCode());
        result = result * 31 + (this.minExpiryDelay == null ? 0 : this.minExpiryDelay.hashCode());
        result = result * 31 + (this.expiryQueueSuffix == null ? 0 : this.expiryQueueSuffix.hashCode());
        result = result * 31 + (this.pageMaxCacheSize == null ? 0 : this.pageMaxCacheSize.hashCode());
        result = result * 31 + (this.defaultConsumersBeforeDispatch == null ? 0 : this.defaultConsumersBeforeDispatch.hashCode());
        result = result * 31 + (this.configDeleteQueues == null ? 0 : this.configDeleteQueues.hashCode());
        result = result * 31 + (this.expiryAddress == null ? 0 : this.expiryAddress.hashCode());
        result = result * 31 + (this.autoDeleteCreatedQueues == null ? 0 : this.autoDeleteCreatedQueues.hashCode());
        result = result * 31 + (this.managementBrowsePageSize == null ? 0 : this.managementBrowsePageSize.hashCode());
        result = result * 31 + (this.autoDeleteQueues == null ? 0 : this.autoDeleteQueues.hashCode());
        result = result * 31 + (this.retroactiveMessageCount == null ? 0 : this.retroactiveMessageCount.hashCode());
        result = result * 31 + (this.maxExpiryDelay == null ? 0 : this.maxExpiryDelay.hashCode());
        result = result * 31 + (this.lastValueQueue == null ? 0 : this.lastValueQueue.hashCode());
        result = result * 31 + (this.maxDeliveryAttempts == null ? 0 : this.maxDeliveryAttempts.hashCode());
        result = result * 31 + (this.defaultGroupFirstKey == null ? 0 : this.defaultGroupFirstKey.hashCode());
        result = result * 31 + (this.autoDeleteJmsQueues == null ? 0 : this.autoDeleteJmsQueues.hashCode());
        result = result * 31 + (this.slowConsumerCheckPeriod == null ? 0 : this.slowConsumerCheckPeriod.hashCode());
        result = result * 31 + (this.defaultPurgeOnNoConsumers == null ? 0 : this.defaultPurgeOnNoConsumers.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.defaultLastValueKey == null ? 0 : this.defaultLastValueKey.hashCode());
        result = result * 31 + (this.autoCreateQueues == null ? 0 : this.autoCreateQueues.hashCode());
        result = result * 31 + (this.defaultExclusiveQueue == null ? 0 : this.defaultExclusiveQueue.hashCode());
        result = result * 31 + (this.sendToDlaOnNoRoute == null ? 0 : this.sendToDlaOnNoRoute.hashCode());
        result = result * 31 + (this.defaultMaxConsumers == null ? 0 : this.defaultMaxConsumers.hashCode());
        result = result * 31 + (this.defaultQueueRoutingType == null ? 0 : this.defaultQueueRoutingType.hashCode());
        result = result * 31 + (this.messageCounterHistoryDayLimit == null ? 0 : this.messageCounterHistoryDayLimit.hashCode());
        result = result * 31 + (this.defaultGroupRebalance == null ? 0 : this.defaultGroupRebalance.hashCode());
        result = result * 31 + (this.maxSizeBytesRejectThreshold == null ? 0 : this.maxSizeBytesRejectThreshold.hashCode());
        result = result * 31 + (this.defaultAddressRoutingType == null ? 0 : this.defaultAddressRoutingType.hashCode());
        result = result * 31 + (this.autoCreateDeadLetterResources == null ? 0 : this.autoCreateDeadLetterResources.hashCode());
        result = result * 31 + (this.autoCreateJmsQueues == null ? 0 : this.autoCreateJmsQueues.hashCode());
        result = result * 31 + (this.autoDeleteJmsTopics == null ? 0 : this.autoDeleteJmsTopics.hashCode());
        result = result * 31 + (this.maxRedeliveryDelay == null ? 0 : this.maxRedeliveryDelay.hashCode());
        result = result * 31 + (this.deadLetterAddress == null ? 0 : this.deadLetterAddress.hashCode());
        result = result * 31 + (this.configDeleteAddresses == null ? 0 : this.configDeleteAddresses.hashCode());
        result = result * 31 + (this.autoDeleteQueuesMessageCount == null ? 0 : this.autoDeleteQueuesMessageCount.hashCode());
        result = result * 31 + (this.autoDeleteAddresses == null ? 0 : this.autoDeleteAddresses.hashCode());
        result = result * 31 + (this.maxSizeBytes == null ? 0 : this.maxSizeBytes.hashCode());
        result = result * 31 + (this.defaultDelayBeforeDispatch == null ? 0 : this.defaultDelayBeforeDispatch.hashCode());
        result = result * 31 + (this.redistributionDelay == null ? 0 : this.redistributionDelay.hashCode());
        result = result * 31 + (this.defaultRingSize == null ? 0 : this.defaultRingSize.hashCode());
        result = result * 31 + (this.match == null ? 0 : this.match.hashCode());
        result = result * 31 + (this.defaultLastValueQueue == null ? 0 : this.defaultLastValueQueue.hashCode());
        result = result * 31 + (this.slowConsumerPolicy == null ? 0 : this.slowConsumerPolicy.hashCode());
        result = result * 31 + (this.redeliveryCollisionAvoidanceFactor == null ? 0 : this.redeliveryCollisionAvoidanceFactor.hashCode());
        result = result * 31 + (this.autoDeleteQueuesDelay == null ? 0 : this.autoDeleteQueuesDelay.hashCode());
        result = result * 31 + (this.autoDeleteAddressesDelay == null ? 0 : this.autoDeleteAddressesDelay.hashCode());
        result = result * 31 + (this.addressFullPolicy == null ? 0 : this.addressFullPolicy.hashCode());
        result = result * 31 + (this.expiryDelay == null ? 0 : this.expiryDelay.hashCode());
        result = result * 31 + (this.enableMetrics == null ? 0 : this.enableMetrics.hashCode());
        result = result * 31 + (this.redeliveryDelayMultiplier == null ? 0 : this.redeliveryDelayMultiplier.hashCode());
        result = result * 31 + (this.autoCreateJmsTopics == null ? 0 : this.autoCreateJmsTopics.hashCode());
        result = result * 31 + (this.redeliveryDelay == null ? 0 : this.redeliveryDelay.hashCode());
        result = result * 31 + (this.deadLetterQueueSuffix == null ? 0 : this.deadLetterQueueSuffix.hashCode());
        result = result * 31 + (this.defaultNonDestructive == null ? 0 : this.defaultNonDestructive.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AddressSetting)) {
            return false;
        }
        AddressSetting rhs = (AddressSetting)other;
        return (this.expiryQueuePrefix == rhs.expiryQueuePrefix || this.expiryQueuePrefix != null && this.expiryQueuePrefix.equals(rhs.expiryQueuePrefix)) && (this.defaultConsumerWindowSize == rhs.defaultConsumerWindowSize || this.defaultConsumerWindowSize != null && this.defaultConsumerWindowSize.equals(rhs.defaultConsumerWindowSize)) && (this.deadLetterQueuePrefix == rhs.deadLetterQueuePrefix || this.deadLetterQueuePrefix != null && this.deadLetterQueuePrefix.equals(rhs.deadLetterQueuePrefix)) && (this.defaultGroupRebalancePauseDispatch == rhs.defaultGroupRebalancePauseDispatch || this.defaultGroupRebalancePauseDispatch != null && this.defaultGroupRebalancePauseDispatch.equals(rhs.defaultGroupRebalancePauseDispatch)) && (this.autoCreateAddresses == rhs.autoCreateAddresses || this.autoCreateAddresses != null && this.autoCreateAddresses.equals(rhs.autoCreateAddresses)) && (this.defaultGroupBuckets == rhs.defaultGroupBuckets || this.defaultGroupBuckets != null && this.defaultGroupBuckets.equals(rhs.defaultGroupBuckets)) && (this.slowConsumerThreshold == rhs.slowConsumerThreshold || this.slowConsumerThreshold != null && this.slowConsumerThreshold.equals(rhs.slowConsumerThreshold)) && (this.autoCreateExpiryResources == rhs.autoCreateExpiryResources || this.autoCreateExpiryResources != null && this.autoCreateExpiryResources.equals(rhs.autoCreateExpiryResources)) && (this.pageSizeBytes == rhs.pageSizeBytes || this.pageSizeBytes != null && this.pageSizeBytes.equals(rhs.pageSizeBytes)) && (this.minExpiryDelay == rhs.minExpiryDelay || this.minExpiryDelay != null && this.minExpiryDelay.equals(rhs.minExpiryDelay)) && (this.expiryQueueSuffix == rhs.expiryQueueSuffix || this.expiryQueueSuffix != null && this.expiryQueueSuffix.equals(rhs.expiryQueueSuffix)) && (this.pageMaxCacheSize == rhs.pageMaxCacheSize || this.pageMaxCacheSize != null && this.pageMaxCacheSize.equals(rhs.pageMaxCacheSize)) && (this.defaultConsumersBeforeDispatch == rhs.defaultConsumersBeforeDispatch || this.defaultConsumersBeforeDispatch != null && this.defaultConsumersBeforeDispatch.equals(rhs.defaultConsumersBeforeDispatch)) && (this.configDeleteQueues == rhs.configDeleteQueues || this.configDeleteQueues != null && this.configDeleteQueues.equals((Object)rhs.configDeleteQueues)) && (this.expiryAddress == rhs.expiryAddress || this.expiryAddress != null && this.expiryAddress.equals(rhs.expiryAddress)) && (this.autoDeleteCreatedQueues == rhs.autoDeleteCreatedQueues || this.autoDeleteCreatedQueues != null && this.autoDeleteCreatedQueues.equals(rhs.autoDeleteCreatedQueues)) && (this.managementBrowsePageSize == rhs.managementBrowsePageSize || this.managementBrowsePageSize != null && this.managementBrowsePageSize.equals(rhs.managementBrowsePageSize)) && (this.autoDeleteQueues == rhs.autoDeleteQueues || this.autoDeleteQueues != null && this.autoDeleteQueues.equals(rhs.autoDeleteQueues)) && (this.retroactiveMessageCount == rhs.retroactiveMessageCount || this.retroactiveMessageCount != null && this.retroactiveMessageCount.equals(rhs.retroactiveMessageCount)) && (this.maxExpiryDelay == rhs.maxExpiryDelay || this.maxExpiryDelay != null && this.maxExpiryDelay.equals(rhs.maxExpiryDelay)) && (this.lastValueQueue == rhs.lastValueQueue || this.lastValueQueue != null && this.lastValueQueue.equals(rhs.lastValueQueue)) && (this.maxDeliveryAttempts == rhs.maxDeliveryAttempts || this.maxDeliveryAttempts != null && this.maxDeliveryAttempts.equals(rhs.maxDeliveryAttempts)) && (this.defaultGroupFirstKey == rhs.defaultGroupFirstKey || this.defaultGroupFirstKey != null && this.defaultGroupFirstKey.equals(rhs.defaultGroupFirstKey)) && (this.autoDeleteJmsQueues == rhs.autoDeleteJmsQueues || this.autoDeleteJmsQueues != null && this.autoDeleteJmsQueues.equals(rhs.autoDeleteJmsQueues)) && (this.slowConsumerCheckPeriod == rhs.slowConsumerCheckPeriod || this.slowConsumerCheckPeriod != null && this.slowConsumerCheckPeriod.equals(rhs.slowConsumerCheckPeriod)) && (this.defaultPurgeOnNoConsumers == rhs.defaultPurgeOnNoConsumers || this.defaultPurgeOnNoConsumers != null && this.defaultPurgeOnNoConsumers.equals(rhs.defaultPurgeOnNoConsumers)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.defaultLastValueKey == rhs.defaultLastValueKey || this.defaultLastValueKey != null && this.defaultLastValueKey.equals(rhs.defaultLastValueKey)) && (this.autoCreateQueues == rhs.autoCreateQueues || this.autoCreateQueues != null && this.autoCreateQueues.equals(rhs.autoCreateQueues)) && (this.defaultExclusiveQueue == rhs.defaultExclusiveQueue || this.defaultExclusiveQueue != null && this.defaultExclusiveQueue.equals(rhs.defaultExclusiveQueue)) && (this.sendToDlaOnNoRoute == rhs.sendToDlaOnNoRoute || this.sendToDlaOnNoRoute != null && this.sendToDlaOnNoRoute.equals(rhs.sendToDlaOnNoRoute)) && (this.defaultMaxConsumers == rhs.defaultMaxConsumers || this.defaultMaxConsumers != null && this.defaultMaxConsumers.equals(rhs.defaultMaxConsumers)) && (this.defaultQueueRoutingType == rhs.defaultQueueRoutingType || this.defaultQueueRoutingType != null && this.defaultQueueRoutingType.equals((Object)rhs.defaultQueueRoutingType)) && (this.messageCounterHistoryDayLimit == rhs.messageCounterHistoryDayLimit || this.messageCounterHistoryDayLimit != null && this.messageCounterHistoryDayLimit.equals(rhs.messageCounterHistoryDayLimit)) && (this.defaultGroupRebalance == rhs.defaultGroupRebalance || this.defaultGroupRebalance != null && this.defaultGroupRebalance.equals(rhs.defaultGroupRebalance)) && (this.maxSizeBytesRejectThreshold == rhs.maxSizeBytesRejectThreshold || this.maxSizeBytesRejectThreshold != null && this.maxSizeBytesRejectThreshold.equals(rhs.maxSizeBytesRejectThreshold)) && (this.defaultAddressRoutingType == rhs.defaultAddressRoutingType || this.defaultAddressRoutingType != null && this.defaultAddressRoutingType.equals((Object)rhs.defaultAddressRoutingType)) && (this.autoCreateDeadLetterResources == rhs.autoCreateDeadLetterResources || this.autoCreateDeadLetterResources != null && this.autoCreateDeadLetterResources.equals(rhs.autoCreateDeadLetterResources)) && (this.autoCreateJmsQueues == rhs.autoCreateJmsQueues || this.autoCreateJmsQueues != null && this.autoCreateJmsQueues.equals(rhs.autoCreateJmsQueues)) && (this.autoDeleteJmsTopics == rhs.autoDeleteJmsTopics || this.autoDeleteJmsTopics != null && this.autoDeleteJmsTopics.equals(rhs.autoDeleteJmsTopics)) && (this.maxRedeliveryDelay == rhs.maxRedeliveryDelay || this.maxRedeliveryDelay != null && this.maxRedeliveryDelay.equals(rhs.maxRedeliveryDelay)) && (this.deadLetterAddress == rhs.deadLetterAddress || this.deadLetterAddress != null && this.deadLetterAddress.equals(rhs.deadLetterAddress)) && (this.configDeleteAddresses == rhs.configDeleteAddresses || this.configDeleteAddresses != null && this.configDeleteAddresses.equals((Object)rhs.configDeleteAddresses)) && (this.autoDeleteQueuesMessageCount == rhs.autoDeleteQueuesMessageCount || this.autoDeleteQueuesMessageCount != null && this.autoDeleteQueuesMessageCount.equals(rhs.autoDeleteQueuesMessageCount)) && (this.autoDeleteAddresses == rhs.autoDeleteAddresses || this.autoDeleteAddresses != null && this.autoDeleteAddresses.equals(rhs.autoDeleteAddresses)) && (this.maxSizeBytes == rhs.maxSizeBytes || this.maxSizeBytes != null && this.maxSizeBytes.equals(rhs.maxSizeBytes)) && (this.defaultDelayBeforeDispatch == rhs.defaultDelayBeforeDispatch || this.defaultDelayBeforeDispatch != null && this.defaultDelayBeforeDispatch.equals(rhs.defaultDelayBeforeDispatch)) && (this.redistributionDelay == rhs.redistributionDelay || this.redistributionDelay != null && this.redistributionDelay.equals(rhs.redistributionDelay)) && (this.defaultRingSize == rhs.defaultRingSize || this.defaultRingSize != null && this.defaultRingSize.equals(rhs.defaultRingSize)) && (this.match == rhs.match || this.match != null && this.match.equals(rhs.match)) && (this.defaultLastValueQueue == rhs.defaultLastValueQueue || this.defaultLastValueQueue != null && this.defaultLastValueQueue.equals(rhs.defaultLastValueQueue)) && (this.slowConsumerPolicy == rhs.slowConsumerPolicy || this.slowConsumerPolicy != null && this.slowConsumerPolicy.equals((Object)rhs.slowConsumerPolicy)) && (this.redeliveryCollisionAvoidanceFactor == rhs.redeliveryCollisionAvoidanceFactor || this.redeliveryCollisionAvoidanceFactor != null && this.redeliveryCollisionAvoidanceFactor.equals(rhs.redeliveryCollisionAvoidanceFactor)) && (this.autoDeleteQueuesDelay == rhs.autoDeleteQueuesDelay || this.autoDeleteQueuesDelay != null && this.autoDeleteQueuesDelay.equals(rhs.autoDeleteQueuesDelay)) && (this.autoDeleteAddressesDelay == rhs.autoDeleteAddressesDelay || this.autoDeleteAddressesDelay != null && this.autoDeleteAddressesDelay.equals(rhs.autoDeleteAddressesDelay)) && (this.addressFullPolicy == rhs.addressFullPolicy || this.addressFullPolicy != null && this.addressFullPolicy.equals((Object)rhs.addressFullPolicy)) && (this.expiryDelay == rhs.expiryDelay || this.expiryDelay != null && this.expiryDelay.equals(rhs.expiryDelay)) && (this.enableMetrics == rhs.enableMetrics || this.enableMetrics != null && this.enableMetrics.equals(rhs.enableMetrics)) && (this.redeliveryDelayMultiplier == rhs.redeliveryDelayMultiplier || this.redeliveryDelayMultiplier != null && this.redeliveryDelayMultiplier.equals(rhs.redeliveryDelayMultiplier)) && (this.autoCreateJmsTopics == rhs.autoCreateJmsTopics || this.autoCreateJmsTopics != null && this.autoCreateJmsTopics.equals(rhs.autoCreateJmsTopics)) && (this.redeliveryDelay == rhs.redeliveryDelay || this.redeliveryDelay != null && this.redeliveryDelay.equals(rhs.redeliveryDelay)) && (this.deadLetterQueueSuffix == rhs.deadLetterQueueSuffix || this.deadLetterQueueSuffix != null && this.deadLetterQueueSuffix.equals(rhs.deadLetterQueueSuffix)) && (this.defaultNonDestructive == rhs.defaultNonDestructive || this.defaultNonDestructive != null && this.defaultNonDestructive.equals(rhs.defaultNonDestructive));
    }

    public static enum SlowConsumerPolicy {
        KILL("KILL"),
        NOTIFY("NOTIFY");

        private final String value;
        private static final Map<String, SlowConsumerPolicy> CONSTANTS;

        private SlowConsumerPolicy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SlowConsumerPolicy fromValue(String value) {
            SlowConsumerPolicy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SlowConsumerPolicy>();
            for (SlowConsumerPolicy c : SlowConsumerPolicy.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum DefaultQueueRoutingType {
        ANYCAST("ANYCAST"),
        MULTICAST("MULTICAST");

        private final String value;
        private static final Map<String, DefaultQueueRoutingType> CONSTANTS;

        private DefaultQueueRoutingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DefaultQueueRoutingType fromValue(String value) {
            DefaultQueueRoutingType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DefaultQueueRoutingType>();
            for (DefaultQueueRoutingType c : DefaultQueueRoutingType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum DefaultAddressRoutingType {
        ANYCAST("ANYCAST"),
        MULTICAST("MULTICAST");

        private final String value;
        private static final Map<String, DefaultAddressRoutingType> CONSTANTS;

        private DefaultAddressRoutingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DefaultAddressRoutingType fromValue(String value) {
            DefaultAddressRoutingType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DefaultAddressRoutingType>();
            for (DefaultAddressRoutingType c : DefaultAddressRoutingType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ConfigDeleteQueues {
        OFF("OFF"),
        FORCE("FORCE");

        private final String value;
        private static final Map<String, ConfigDeleteQueues> CONSTANTS;

        private ConfigDeleteQueues(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ConfigDeleteQueues fromValue(String value) {
            ConfigDeleteQueues constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ConfigDeleteQueues>();
            for (ConfigDeleteQueues c : ConfigDeleteQueues.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ConfigDeleteAddresses {
        OFF("OFF"),
        FORCE("FORCE");

        private final String value;
        private static final Map<String, ConfigDeleteAddresses> CONSTANTS;

        private ConfigDeleteAddresses(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ConfigDeleteAddresses fromValue(String value) {
            ConfigDeleteAddresses constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ConfigDeleteAddresses>();
            for (ConfigDeleteAddresses c : ConfigDeleteAddresses.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AddressFullPolicy {
        DROP("DROP"),
        FAIL("FAIL"),
        PAGE("PAGE"),
        BLOCK("BLOCK");

        private final String value;
        private static final Map<String, AddressFullPolicy> CONSTANTS;

        private AddressFullPolicy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AddressFullPolicy fromValue(String value) {
            AddressFullPolicy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AddressFullPolicy>();
            for (AddressFullPolicy c : AddressFullPolicy.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

