/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.jms.amq.service.openshift.generated;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"port", "verifyHost", "wantClientAuth", "expose", "enabledCipherSuites", "host", "needClientAuth", "name", "sslEnabled", "sniHost", "enabledProtocols", "type", "sslSecret", "sslProvider"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Connector
implements KubernetesResource {
    @JsonProperty(value="port")
    @JsonPropertyDescription(value="Port number")
    private Integer port;
    @JsonProperty(value="verifyHost")
    @JsonPropertyDescription(value="The CN of the connecting client's SSL certificate will be compared to its hostname to verify they match. This is useful only for 2-way SSL.")
    private Boolean verifyHost;
    @JsonProperty(value="wantClientAuth")
    @JsonPropertyDescription(value="Tells a client connecting to this acceptor that 2-way SSL is requested but not required. Overridden by needClientAuth.")
    private Boolean wantClientAuth;
    @JsonProperty(value="expose")
    @JsonPropertyDescription(value="Whether or not to expose this connector")
    private Boolean expose;
    @JsonProperty(value="enabledCipherSuites")
    @JsonPropertyDescription(value="Comma separated list of cipher suites used for SSL communication.")
    private String enabledCipherSuites;
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="Hostname or IP to connect to")
    private String host;
    @JsonProperty(value="needClientAuth")
    @JsonPropertyDescription(value="Tells a client connecting to this acceptor that 2-way SSL is required. This property takes precedence over wantClientAuth.")
    private Boolean needClientAuth;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of the acceptor")
    private String name;
    @JsonProperty(value="sslEnabled")
    @JsonPropertyDescription(value="Whether or not to enable SSL on this port")
    private Boolean sslEnabled;
    @JsonProperty(value="sniHost")
    @JsonPropertyDescription(value="A regular expression used to match the server_name extension on incoming SSL connections. If the name doesn't match then the connection to the acceptor will be rejected.")
    private String sniHost;
    @JsonProperty(value="enabledProtocols")
    @JsonPropertyDescription(value="Comma separated list of protocols used for SSL communication.")
    private String enabledProtocols;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type either tcp or vm")
    private String type;
    @JsonProperty(value="sslSecret")
    @JsonPropertyDescription(value="Name of the secret to use for ssl information")
    private String sslSecret;
    @JsonProperty(value="sslProvider")
    @JsonPropertyDescription(value="Used to change the SSL Provider between JDK and OPENSSL. The default is JDK.")
    private String sslProvider;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    public void setPort(Integer port) {
        this.port = port;
    }

    public Connector withPort(Integer port) {
        this.port = port;
        return this;
    }

    @JsonProperty(value="verifyHost")
    public Boolean getVerifyHost() {
        return this.verifyHost;
    }

    @JsonProperty(value="verifyHost")
    public void setVerifyHost(Boolean verifyHost) {
        this.verifyHost = verifyHost;
    }

    public Connector withVerifyHost(Boolean verifyHost) {
        this.verifyHost = verifyHost;
        return this;
    }

    @JsonProperty(value="wantClientAuth")
    public Boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    @JsonProperty(value="wantClientAuth")
    public void setWantClientAuth(Boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public Connector withWantClientAuth(Boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
        return this;
    }

    @JsonProperty(value="expose")
    public Boolean getExpose() {
        return this.expose;
    }

    @JsonProperty(value="expose")
    public void setExpose(Boolean expose) {
        this.expose = expose;
    }

    public Connector withExpose(Boolean expose) {
        this.expose = expose;
        return this;
    }

    @JsonProperty(value="enabledCipherSuites")
    public String getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    @JsonProperty(value="enabledCipherSuites")
    public void setEnabledCipherSuites(String enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public Connector withEnabledCipherSuites(String enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
        return this;
    }

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    public void setHost(String host) {
        this.host = host;
    }

    public Connector withHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty(value="needClientAuth")
    public Boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    @JsonProperty(value="needClientAuth")
    public void setNeedClientAuth(Boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public Connector withNeedClientAuth(Boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Connector withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="sslEnabled")
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    @JsonProperty(value="sslEnabled")
    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public Connector withSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    @JsonProperty(value="sniHost")
    public String getSniHost() {
        return this.sniHost;
    }

    @JsonProperty(value="sniHost")
    public void setSniHost(String sniHost) {
        this.sniHost = sniHost;
    }

    public Connector withSniHost(String sniHost) {
        this.sniHost = sniHost;
        return this;
    }

    @JsonProperty(value="enabledProtocols")
    public String getEnabledProtocols() {
        return this.enabledProtocols;
    }

    @JsonProperty(value="enabledProtocols")
    public void setEnabledProtocols(String enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public Connector withEnabledProtocols(String enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public Connector withType(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="sslSecret")
    public String getSslSecret() {
        return this.sslSecret;
    }

    @JsonProperty(value="sslSecret")
    public void setSslSecret(String sslSecret) {
        this.sslSecret = sslSecret;
    }

    public Connector withSslSecret(String sslSecret) {
        this.sslSecret = sslSecret;
        return this;
    }

    @JsonProperty(value="sslProvider")
    public String getSslProvider() {
        return this.sslProvider;
    }

    @JsonProperty(value="sslProvider")
    public void setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
    }

    public Connector withSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Connector withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Connector.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("port");
        sb.append('=');
        sb.append(this.port == null ? "<null>" : this.port);
        sb.append(',');
        sb.append("verifyHost");
        sb.append('=');
        sb.append(this.verifyHost == null ? "<null>" : this.verifyHost);
        sb.append(',');
        sb.append("wantClientAuth");
        sb.append('=');
        sb.append(this.wantClientAuth == null ? "<null>" : this.wantClientAuth);
        sb.append(',');
        sb.append("expose");
        sb.append('=');
        sb.append(this.expose == null ? "<null>" : this.expose);
        sb.append(',');
        sb.append("enabledCipherSuites");
        sb.append('=');
        sb.append(this.enabledCipherSuites == null ? "<null>" : this.enabledCipherSuites);
        sb.append(',');
        sb.append("host");
        sb.append('=');
        sb.append(this.host == null ? "<null>" : this.host);
        sb.append(',');
        sb.append("needClientAuth");
        sb.append('=');
        sb.append(this.needClientAuth == null ? "<null>" : this.needClientAuth);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("sslEnabled");
        sb.append('=');
        sb.append(this.sslEnabled == null ? "<null>" : this.sslEnabled);
        sb.append(',');
        sb.append("sniHost");
        sb.append('=');
        sb.append(this.sniHost == null ? "<null>" : this.sniHost);
        sb.append(',');
        sb.append("enabledProtocols");
        sb.append('=');
        sb.append(this.enabledProtocols == null ? "<null>" : this.enabledProtocols);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("sslSecret");
        sb.append('=');
        sb.append(this.sslSecret == null ? "<null>" : this.sslSecret);
        sb.append(',');
        sb.append("sslProvider");
        sb.append('=');
        sb.append(this.sslProvider == null ? "<null>" : this.sslProvider);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.needClientAuth == null ? 0 : this.needClientAuth.hashCode());
        result = result * 31 + (this.enabledProtocols == null ? 0 : this.enabledProtocols.hashCode());
        result = result * 31 + (this.verifyHost == null ? 0 : this.verifyHost.hashCode());
        result = result * 31 + (this.sslProvider == null ? 0 : this.sslProvider.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.expose == null ? 0 : this.expose.hashCode());
        result = result * 31 + (this.wantClientAuth == null ? 0 : this.wantClientAuth.hashCode());
        result = result * 31 + (this.enabledCipherSuites == null ? 0 : this.enabledCipherSuites.hashCode());
        result = result * 31 + (this.port == null ? 0 : this.port.hashCode());
        result = result * 31 + (this.sslEnabled == null ? 0 : this.sslEnabled.hashCode());
        result = result * 31 + (this.host == null ? 0 : this.host.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.sslSecret == null ? 0 : this.sslSecret.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.sniHost == null ? 0 : this.sniHost.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Connector)) {
            return false;
        }
        Connector rhs = (Connector)other;
        return (this.needClientAuth == rhs.needClientAuth || this.needClientAuth != null && this.needClientAuth.equals(rhs.needClientAuth)) && (this.enabledProtocols == rhs.enabledProtocols || this.enabledProtocols != null && this.enabledProtocols.equals(rhs.enabledProtocols)) && (this.verifyHost == rhs.verifyHost || this.verifyHost != null && this.verifyHost.equals(rhs.verifyHost)) && (this.sslProvider == rhs.sslProvider || this.sslProvider != null && this.sslProvider.equals(rhs.sslProvider)) && (this.type == rhs.type || this.type != null && this.type.equals(rhs.type)) && (this.expose == rhs.expose || this.expose != null && this.expose.equals(rhs.expose)) && (this.wantClientAuth == rhs.wantClientAuth || this.wantClientAuth != null && this.wantClientAuth.equals(rhs.wantClientAuth)) && (this.enabledCipherSuites == rhs.enabledCipherSuites || this.enabledCipherSuites != null && this.enabledCipherSuites.equals(rhs.enabledCipherSuites)) && (this.port == rhs.port || this.port != null && this.port.equals(rhs.port)) && (this.sslEnabled == rhs.sslEnabled || this.sslEnabled != null && this.sslEnabled.equals(rhs.sslEnabled)) && (this.host == rhs.host || this.host != null && this.host.equals(rhs.host)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.sslSecret == rhs.sslSecret || this.sslSecret != null && this.sslSecret.equals(rhs.sslSecret)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.sniHost == rhs.sniHost || this.sniHost != null && this.sniHost.equals(rhs.sniHost));
    }
}

