/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.jms.amq.service.local;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.common.deployment.WithDockerImage;
import software.tnb.jms.amq.service.AMQBroker;
import software.tnb.jms.amq.service.local.AMQBrokerContainer;

@AutoService(value={AMQBroker.class})
public class LocalAMQBroker
extends AMQBroker
implements Deployable,
WithDockerImage {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAMQBroker.class);
    private AMQBrokerContainer container;

    public void deploy() {
        LOG.info("Starting AMQ container");
        this.container = new AMQBrokerContainer(this.image(), this.containerEnvironment(), this.containerPorts());
        this.container.start();
        LOG.info("AMQ broker container started");
    }

    public void undeploy() {
        if (this.container != null) {
            LOG.info("Stopping AMQ broker container");
            this.container.stop();
        }
    }

    public void openResources() {
        this.connection = this.createConnection();
    }

    public void closeResources() {
        try {
            this.connection.close();
        }
        catch (JMSException e) {
            throw new RuntimeException("Can't close JMS connection", e);
        }
    }

    @Override
    public String brokerUrl() {
        return "localhost";
    }

    @Override
    protected String mqttUrl() {
        return String.format("tcp://%s:%d", this.brokerUrl(), this.getPortMapping(1883));
    }

    @Override
    public int getPortMapping(int port) {
        return this.container.getMappedPort(port);
    }

    private int[] containerPorts() {
        return new int[]{8161, 61616, 1883};
    }

    private Map<String, String> containerEnvironment() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("AMQ_USER", this.account().username());
        env.put("AMQ_PASSWORD", this.account().password());
        env.put("AMQ_ROLE", "admin");
        env.put("AMQ_NAME", "broker");
        env.put("AMQ_TRANSPORTS", "openwire,amqp,stomp,mqtt,hornetq");
        env.put("AMQ_REQUIRE_LOGIN", "true");
        return env;
    }

    private Connection createConnection() {
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(String.format("tcp://%s:%s", this.brokerUrl(), this.getPortMapping(61616)), this.account().username(), this.account().password());
            Connection connection = connectionFactory.createConnection();
            connection.start();
            return connection;
        }
        catch (JMSException e) {
            throw new RuntimeException("Can't create jms connection", e);
        }
    }

    public String defaultImage() {
        return "registry.redhat.io/amq7/amq-broker-rhel8:7.10";
    }
}

