/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.jms.amq.validation;

import java.util.UUID;
import javax.jms.Connection;
import software.tnb.jms.amq.account.AMQBrokerAccount;
import software.tnb.jms.client.JMSClientManager;
import software.tnb.jms.client.JMSQueueClient;
import software.tnb.jms.client.JMSTopicClient;
import software.tnb.jms.client.MQTT5TopicClient;
import software.tnb.jms.client.MQTTTopicClient;

public class AMQValidation {
    private final Connection connection;
    private JMSClientManager client;
    private final AMQBrokerAccount account;
    private final String mqttUrl;

    public AMQValidation(Connection connection, AMQBrokerAccount account, String mqttUrl) {
        this.connection = connection;
        this.account = account;
        this.mqttUrl = mqttUrl;
    }

    private JMSClientManager client() {
        if (this.client == null) {
            this.client = new JMSClientManager(this.connection);
        }
        return this.client;
    }

    public JMSQueueClient queue(String queue) {
        return this.client().queue(queue);
    }

    public JMSTopicClient topic(String topic) {
        return this.client().topic(topic);
    }

    public MQTTTopicClient mqtt(String topic) {
        return this.mqtt(topic, UUID.randomUUID().toString());
    }

    public MQTT5TopicClient mqtt5(String topic) {
        return this.mqtt5(topic, UUID.randomUUID().toString());
    }

    public MQTTTopicClient mqtt(String topic, String clientId) {
        return this.client().mqtt(this.mqttUrl, this.account.username(), this.account.password(), clientId, topic);
    }

    public MQTT5TopicClient mqtt5(String topic, String clientId) {
        return this.client().mqtt5(this.mqttUrl, this.account.username(), this.account.password(), clientId, topic);
    }
}

