/*
 * Decompiled with CFR 0.152.
 */
package software.sham.ssh.actions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.sham.ssh.MockSshShell;
import software.sham.ssh.actions.Action;

public class Delay
implements Action {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long milliseconds;

    public Delay(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    @Override
    public void respond(MockSshShell shell) {
        try {
            this.logger.debug("Delaying output for {}ms", (Object)this.milliseconds);
            Thread.sleep(this.milliseconds);
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted before delay completed: {}", (Object)e.getMessage());
        }
    }

    public String toString() {
        return "delay (" + this.milliseconds + "ms)";
    }
}

