/*
 * Decompiled with CFR 0.152.
 */
package software.sham.ssh;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.sham.ssh.actions.Action;

public class SshResponder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<Action> actions = new LinkedList<Action>();
    public static SshResponder NULL = new SshResponder();

    public void respond(OutputStream out) {
        for (Action action : this.actions) {
            try {
                String output = action.respond();
                out.write(output.getBytes());
                this.logger.trace("Wrote output {}", (Object)output);
                out.flush();
            }
            catch (IOException e) {
                this.logger.warn("Mock SSH error during response {}: {}", (Object)action.toString(), (Object)e.getMessage());
            }
        }
    }

    public void add(Action action) {
        this.actions.add(action);
    }
}

