/*
 * Decompiled with CFR 0.152.
 */
package software.sham.ssh;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.sham.ssh.SshResponder;

public class ResponderDispatcher {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Matcher, SshResponder> responders = new HashMap<Matcher, SshResponder>();
    private final LinkedList<Matcher> matchers = new LinkedList();

    public void add(Matcher matcher, SshResponder responder) {
        this.matchers.add(0, matcher);
        this.responders.put(matcher, responder);
    }

    public SshResponder find(String input) {
        for (Matcher matcher : this.matchers) {
            this.logger.debug("checking {}", (Object)matcher.toString());
            if (matcher.matches((Object)input)) {
                this.logger.debug("Found responder for " + matcher.toString());
                return this.responders.get(matcher);
            }
            this.logger.debug("did not match " + matcher.toString());
        }
        this.logger.info("No responder found for input " + input);
        return SshResponder.NULL;
    }
}

