/*
 * Decompiled with CFR 0.152.
 */
package software.sham.ssh;

import java.io.IOException;
import java.util.Arrays;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.keyprovider.AbstractClassLoadableResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.sham.ssh.MockSshShell;
import software.sham.ssh.SshResponderBuilder;

public class MockSshServer
implements Factory<Command>,
CommandFactory {
    public static final String USERNAME = "tester";
    public static final String PASSWORD = "testing";
    protected final SshServer sshServer;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MockSshShell sshShell;

    public MockSshServer(int port) throws IOException {
        this(port, true);
    }

    protected MockSshServer(int port, boolean shouldStartServices) throws IOException {
        this.sshServer = this.initSshServer(port);
        if (shouldStartServices) {
            this.enableShell();
            this.start();
        }
    }

    public SshResponderBuilder respondTo(Matcher matcher) {
        SshResponderBuilder builder = new SshResponderBuilder();
        this.sshShell.getDispatcher().add(matcher, builder.getResponder());
        return builder;
    }

    public SshResponderBuilder respondTo(String input) {
        return this.respondTo(Matchers.equalTo((Object)input));
    }

    public MockSshServer enableShell() {
        this.logger.info("Mock SSH shell is enabled");
        this.sshShell = new MockSshShell();
        this.sshServer.setShellFactory((Factory)this);
        return this;
    }

    public void start() throws IOException {
        AbstractClassLoadableResourceKeyPairProvider keyPairProvider = SecurityUtils.createClassLoadableResourceKeyPairProvider();
        keyPairProvider.setResources(Arrays.asList("keys/sham-ssh-id-dsa"));
        this.sshServer.setKeyPairProvider((KeyPairProvider)keyPairProvider);
        this.sshServer.start();
    }

    public void stop() throws IOException {
        this.sshServer.stop();
    }

    protected SshServer initSshServer(int port) {
        SshServer sshd = SshServer.setUpDefaultServer();
        sshd.setPort(port);
        sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                return MockSshServer.USERNAME.equals(username) && MockSshServer.PASSWORD.equals(password);
            }
        });
        return sshd;
    }

    public Command create() {
        this.logger.debug("Creating mock SSH shell");
        return this.sshShell;
    }

    public Command createCommand(String command) {
        return this.create();
    }
}

