/*
 * Decompiled with CFR 0.152.
 */
package software.sham.sftp;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.AbstractClassLoadableResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSftpServer {
    public static final String USERNAME = "tester";
    public static final String PASSWORD = "testing";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SshServer sshServer;
    private Path baseDirectory;
    private Path workDirectory;

    public MockSftpServer(int port) throws IOException {
        this.sshServer = this.initSftpServer(port);
        this.start();
    }

    public Path getBaseDirectory() {
        return this.baseDirectory;
    }

    protected void start() throws IOException {
        this.baseDirectory = Files.createTempDirectory("sftproot", new FileAttribute[0]);
        this.workDirectory = Files.createTempDirectory("tempsftp-work", new FileAttribute[0]);
        this.logger.info("workDirectory: " + this.workDirectory);
        this.sshServer.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(this.baseDirectory.toAbsolutePath().toString()));
        AbstractClassLoadableResourceKeyPairProvider keyPairProvider = SecurityUtils.createClassLoadableResourceKeyPairProvider();
        keyPairProvider.setResources(Arrays.asList("keys/sham-sftp-id-dsa"));
        this.sshServer.setKeyPairProvider((KeyPairProvider)keyPairProvider);
        this.sshServer.start();
    }

    public void stop() throws IOException {
        this.sshServer.stop();
        FileUtils.deleteQuietly((File)this.baseDirectory.toFile());
        FileUtils.deleteQuietly((File)this.workDirectory.toFile());
    }

    private SshServer initSftpServer(int port) {
        SshServer sshd = SshServer.setUpDefaultServer();
        sshd.setPort(port);
        sshd.setCommandFactory((CommandFactory)new ScpCommandFactory());
        sshd.setSubsystemFactories(Arrays.asList(new SftpSubsystemFactory()));
        sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                return MockSftpServer.USERNAME.equals(username) && MockSftpServer.PASSWORD.equals(password);
            }
        });
        return sshd;
    }
}

