/*
 * Decompiled with CFR 0.152.
 */
package software.sandc.springframework.security.jwt.authority;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.TextCodec;
import java.security.Key;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;
import software.sandc.springframework.security.jwt.JWTRequestResponseHandler;
import software.sandc.springframework.security.jwt.authority.AuthorityKeyProvider;
import software.sandc.springframework.security.jwt.authority.SessionProvider;
import software.sandc.springframework.security.jwt.consumer.JWTConsumer;
import software.sandc.springframework.security.jwt.impl.DefaultSigningKeyResolver;
import software.sandc.springframework.security.jwt.impl.authority.FakeKeyProvider;
import software.sandc.springframework.security.jwt.impl.authority.FakeSessionProvider;
import software.sandc.springframework.security.jwt.model.Credentials;
import software.sandc.springframework.security.jwt.model.JWTAuthentication;
import software.sandc.springframework.security.jwt.model.JWTContext;
import software.sandc.springframework.security.jwt.model.TokenContainer;
import software.sandc.springframework.security.jwt.model.exception.ExpiredTokenException;
import software.sandc.springframework.security.jwt.model.exception.InvalidSessionException;
import software.sandc.springframework.security.jwt.model.exception.TokenRenewalException;
import software.sandc.springframework.security.jwt.model.exception.UserNotFoundException;
import software.sandc.springframework.security.jwt.model.parameter.DisableXSRFParameter;
import software.sandc.springframework.security.jwt.model.parameter.IgnoreExpiryParameter;
import software.sandc.springframework.security.jwt.model.parameter.Parameters;
import software.sandc.springframework.security.jwt.model.parameter.SessionIdParameter;
import software.sandc.springframework.security.jwt.util.BooleanUtils;
import software.sandc.springframework.security.jwt.util.RSAUtils;
import software.sandc.springframework.security.jwt.util.StringUtils;

public class JWTAuthority
extends JWTConsumer
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(JWTAuthority.class);
    protected UserDetailsService userDetailsService;
    protected SessionProvider sessionProvider;
    protected UserDetailsChecker userDetailsChecker;
    protected int tokenLifetimeInSeconds = 600;
    protected int sessionInvalidationDelayInMinutes = 5;
    protected PasswordEncoder passwordEncoder;
    protected AuthorityKeyProvider authorityKeyProvider;
    protected boolean refreshSessionOnAuthentication = false;
    protected boolean refreshSessionOnRenewal = true;

    public JWTAuthority(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    @Override
    public JWTContext authenticateJWTRequest(HttpServletRequest request, HttpServletResponse response) {
        JWTContext jwtContext = null;
        TokenContainer tokenContainer = this.jwtRequestResponseHandler.getTokenFromRequest(request);
        if (tokenContainer != null) {
            block4: {
                try {
                    Parameters parameters = this.jwtRequestResponseHandler.getParametersFromRequest(request);
                    jwtContext = this.validate(tokenContainer, parameters);
                }
                catch (ExpiredTokenException e) {
                    if (!this.isTokenRenewalEnabled()) break block4;
                    Parameters parameters = this.jwtRequestResponseHandler.getParametersFromRequest(request);
                    jwtContext = this.renew(tokenContainer, parameters);
                }
            }
            if (this.refreshSessionOnAuthentication) {
                this.refreshSession(jwtContext);
            }
            this.handleJWTContext(request, response, jwtContext);
        }
        return jwtContext;
    }

    public JWTContext authenticateLoginRequest(Credentials credentials, HttpServletRequest request, HttpServletResponse response) {
        UserDetails userDetails;
        JWTContext jwtContext = null;
        String password = credentials.getPassword();
        String principal = credentials.getPrincipal();
        if (principal != null && password != null && this.passwordEncoder.matches((CharSequence)password, (userDetails = this.userDetailsService.loadUserByUsername(principal)).getPassword())) {
            Parameters parameters = this.jwtRequestResponseHandler.getParametersFromRequest(request);
            jwtContext = this.create(principal, parameters);
            this.handleJWTContext(request, response, jwtContext);
        }
        return jwtContext;
    }

    public JWTContext createAndAttach(String principal, HttpServletRequest request, HttpServletResponse response, Parameters parameters) {
        JWTContext jwtContext = null;
        if (principal != null) {
            Parameters parametersFromRequest = this.jwtRequestResponseHandler.getParametersFromRequest(request);
            if (parametersFromRequest != null) {
                parametersFromRequest.merge(parameters);
                parameters = parametersFromRequest;
            }
            jwtContext = this.create(principal, parameters);
            this.handleJWTContext(request, response, jwtContext);
        }
        return jwtContext;
    }

    public JWTContext createAndAttachInvalidToken(HttpServletRequest request, HttpServletResponse response) {
        String randomUUID = UUID.randomUUID().toString();
        Date now = new Date();
        JwtBuilder jwtBuilder = Jwts.builder().setHeaderParam("kid", (Object)randomUUID).setSubject(randomUUID).setIssuedAt(now).setExpiration(now);
        String jwtToken = jwtBuilder.compact();
        Parameters parameters = this.jwtRequestResponseHandler.getParametersFromRequest(request);
        String jwtMode = this.getJWTModeFromParameters(parameters);
        JWTContext jwtContext = this.createJWTContext(randomUUID, randomUUID, randomUUID, null, jwtMode, jwtToken);
        this.handleJWTContext(request, response, jwtContext);
        return jwtContext;
    }

    public JWTContext create(String principal, Parameters parameters) throws UserNotFoundException {
        if (parameters == null) {
            parameters = new Parameters();
        }
        String keyId = this.authorityKeyProvider.getCurrentSigningKeyId();
        String signingKey = this.authorityKeyProvider.getPrivateKey(keyId);
        SignatureAlgorithm signatureAlgorithm = this.authorityKeyProvider.getSignatureAlgorithm(keyId);
        Date now = new Date();
        Date sessionExpiry = new Date(System.currentTimeMillis() + (long)(this.tokenLifetimeInSeconds * 1000));
        String xsrfToken = null;
        if (!this.isXSRFProtectionDisabled(parameters)) {
            LOGGER.trace("XSRF protection is enabled. Creating XSRF Token.");
            xsrfToken = this.generateXSRFToken();
        } else {
            LOGGER.trace("XSRF protection is disabled. Skipping XSRF Token generation");
        }
        UserDetails userDetails = this.getUserDetails(principal);
        Collection authorities = userDetails.getAuthorities();
        String authoritiesAsString = this.convertToString(authorities);
        Claims claims = Jwts.claims();
        if (xsrfToken != null) {
            claims.put((Object)this.xsrfParameterName, (Object)xsrfToken);
        }
        claims.put((Object)this.authoritiesParameterName, (Object)authoritiesAsString);
        String sessionId = null;
        if (this.sessionProvider != null) {
            sessionId = (String)parameters.getValueOf(SessionIdParameter.class);
            if (sessionId == null || sessionId.isEmpty()) {
                sessionId = this.sessionProvider.createSession(principal);
            }
            if (sessionId != null && !sessionId.isEmpty()) {
                claims.put((Object)this.sessionIdParameterName, (Object)sessionId);
            }
        }
        JwtBuilder jwtBuilder = Jwts.builder().setHeaderParam("kid", (Object)keyId).setClaims(claims).setSubject(userDetails.getUsername()).setIssuedAt(now).setNotBefore(now).setExpiration(sessionExpiry);
        if (signatureAlgorithm.isHmac()) {
            byte[] binarySigningKey = TextCodec.BASE64.decode(signingKey);
            jwtBuilder = jwtBuilder.signWith(signatureAlgorithm, binarySigningKey);
        } else if (signatureAlgorithm.isRsa()) {
            PrivateKey privateKey = RSAUtils.toPrivateKey(signingKey);
            jwtBuilder = jwtBuilder.signWith(signatureAlgorithm, (Key)privateKey);
        } else {
            throw new UnsupportedJwtException("Not supported signature algorithm " + signatureAlgorithm.getValue());
        }
        String jwtToken = jwtBuilder.compact();
        String jwtMode = this.getJWTModeFromParameters(parameters);
        JWTContext jwtContext = this.createJWTContext(principal, sessionId, xsrfToken, authorities, jwtMode, jwtToken);
        return jwtContext;
    }

    public JWTContext renew(HttpServletRequest request, HttpServletResponse response) {
        JWTContext jwtContext = null;
        TokenContainer tokenContainer = this.jwtRequestResponseHandler.getTokenFromRequest(request);
        if (tokenContainer != null) {
            Parameters parameters = this.jwtRequestResponseHandler.getParametersFromRequest(request);
            jwtContext = this.renew(tokenContainer, parameters);
            if (this.refreshSessionOnRenewal) {
                this.refreshSession(jwtContext);
            }
            this.handleJWTContext(request, response, jwtContext);
        }
        return jwtContext;
    }

    public JWTContext renew(TokenContainer tokenContainer, Parameters parameters) {
        if (this.sessionProvider == null) {
            throw new TokenRenewalException("No session provider found for token renewal.");
        }
        boolean ignoreExpiry = true;
        Parameters renewParameters = new Parameters(parameters);
        renewParameters.put(new IgnoreExpiryParameter(ignoreExpiry));
        this.validate(tokenContainer, renewParameters);
        JwtParser jwtParser = Jwts.parser().setSigningKeyResolver(this.signingKeyResolver).setAllowedClockSkewSeconds((long)TEN_YEARS_IN_SECONDS.intValue());
        String jwtToken = tokenContainer.getJwtToken();
        Jws jws = jwtParser.parseClaimsJws(jwtToken);
        Claims claims = (Claims)jws.getBody();
        String sessionId = this.extractSessionId(claims);
        String principal = this.extractPrincipal(claims);
        if (this.sessionProvider.isSessionValid(sessionId)) {
            String renewedSessionId = this.sessionProvider.renewSession(sessionId);
            renewParameters.put(new SessionIdParameter(renewedSessionId));
            JWTContext jwtContext = this.create(principal, parameters);
            return jwtContext;
        }
        throw new InvalidSessionException("Token session does not exist or not valid anymore.");
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userDetailsService, (String)"userDetailsService must be specified");
        if (this.jwtRequestResponseHandler == null) {
            this.jwtRequestResponseHandler = new JWTRequestResponseHandler();
        }
        if (this.authorityKeyProvider == null) {
            this.authorityKeyProvider = new FakeKeyProvider();
        }
        if (this.signingKeyResolver == null) {
            this.signingKeyResolver = new DefaultSigningKeyResolver(this.authorityKeyProvider);
        }
        if (this.sessionProvider == null) {
            this.sessionProvider = new FakeSessionProvider();
        }
        if (this.userDetailsChecker == null) {
            this.userDetailsChecker = new AccountStatusUserDetailsChecker();
        }
        if (this.passwordEncoder == null) {
            this.passwordEncoder = new BCryptPasswordEncoder();
        }
    }

    public boolean isTokenRenewalEnabled() {
        return this.sessionProvider != null;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setSessionProvider(SessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    public void setAuthorityKeyProvider(AuthorityKeyProvider authorityKeyProvider) {
        this.authorityKeyProvider = authorityKeyProvider;
    }

    public void setUserDetailsChecker(UserDetailsChecker userDetailsChecker) {
        Assert.notNull((Object)userDetailsChecker, (String)"userDetailsChacker cannot be null");
        this.userDetailsChecker = userDetailsChecker;
    }

    public void setTokenLifetimeInSeconds(int tokenLifetimeInSeconds) {
        this.tokenLifetimeInSeconds = tokenLifetimeInSeconds;
    }

    public void setSessionInvalidationDelayInMinutes(int sessionInvalidationDelayInMinutes) {
        this.sessionInvalidationDelayInMinutes = sessionInvalidationDelayInMinutes;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public SessionProvider getSessionProvider() {
        return this.sessionProvider;
    }

    public UserDetailsChecker getUserDetailsChecker() {
        return this.userDetailsChecker;
    }

    public int getTokenLifetimeInSeconds() {
        return this.tokenLifetimeInSeconds;
    }

    public int getSessionInvalidationDelayInMinutes() {
        return this.sessionInvalidationDelayInMinutes;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public AuthorityKeyProvider getAuthorityKeyProvider() {
        return this.authorityKeyProvider;
    }

    public void setRefreshSessionOnAuthentication(boolean refreshSessionOnAuthentication) {
        this.refreshSessionOnAuthentication = refreshSessionOnAuthentication;
    }

    public void setRefreshSessionOnRenewal(boolean refreshSessionOnRenewal) {
        this.refreshSessionOnRenewal = refreshSessionOnRenewal;
    }

    protected String generateXSRFToken() {
        return UUID.randomUUID().toString();
    }

    protected String convertToString(Collection<? extends GrantedAuthority> authorities) {
        List<String> authoriesAsStringList = this.getAuthorityListAsString(authorities);
        String authoritiesAsString = StringUtils.join(authoriesAsStringList, ",");
        return authoritiesAsString;
    }

    protected UserDetails getUserDetails(String principal) {
        try {
            UserDetails user = this.userDetailsService.loadUserByUsername(principal);
            this.userDetailsChecker.check(user);
            return user;
        }
        catch (UsernameNotFoundException e) {
            throw new UserNotFoundException("User with principal: " + principal + " cannot be found.", e);
        }
    }

    protected List<String> getAuthorityListAsString(Collection<? extends GrantedAuthority> authorities) {
        ArrayList<String> authoritiesAsString = new ArrayList<String>();
        if (authorities != null) {
            for (GrantedAuthority grantedAuthority : authorities) {
                authoritiesAsString.add(grantedAuthority.getAuthority());
            }
        }
        return authoritiesAsString;
    }

    protected void refreshSession(JWTContext jwtContext) {
        if (jwtContext != null && jwtContext.isAuthenticated() && this.sessionProvider != null) {
            JWTAuthentication authentication = jwtContext.getAuthentication();
            this.sessionProvider.refreshSession(authentication.getSessionId());
        }
    }

    @Override
    protected void handleJWTContext(HttpServletRequest request, HttpServletResponse response, JWTContext jwtContext) {
        if (jwtContext != null && jwtContext.isAuthenticated()) {
            JWTAuthentication authentication = jwtContext.getAuthentication();
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            this.jwtRequestResponseHandler.putTokenToResponse(request, response, jwtContext.getTokenContainer());
        }
    }

    protected boolean isXSRFProtectionDisabled(Parameters parameters) {
        if (parameters != null) {
            Boolean isXSRFProtectionDisabled = (Boolean)parameters.getValueOf(DisableXSRFParameter.class);
            return BooleanUtils.isTrue(isXSRFProtectionDisabled);
        }
        return false;
    }
}

