/*
 * Decompiled with CFR 0.152.
 */
package software.sandc.springframework.security.jwt;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.util.WebUtils;
import software.sandc.springframework.security.jwt.model.TokenContainer;
import software.sandc.springframework.security.jwt.model.parameter.DisableXSRFParameter;
import software.sandc.springframework.security.jwt.model.parameter.Parameters;

public class JWTRequestResponseHandler {
    public static final String SPRING_SECURITY_JWT_COOKIE_JWT_PARAMETER = "JWT-TOKEN";
    public static final String SPRING_SECURITY_JWT_COOKIE_XSRF_PARAMETER = "XSRF-TOKEN";
    public static final String SPRING_SECURITY_JWT_RESPONSE_HEADER_XSRF = "XSRF-TOKEN";
    public static final String SPRING_SECURITY_JWT_REQUEST_HEADER_XSRF = "X-XSRF-TOKEN";
    public static final String SPRING_SECURITY_JWT_REQUEST_HEADER_JWT = "X-JWT-TOKEN";
    public static final String SPRING_SECURITY_JWT_REQUEST_HEADER_JWT_MODE = "X-JWT-MODE";
    public static final String SPRING_SECURITY_JWT_RESPONSE_HEADER_JWT = "JWT-TOKEN";
    public static final String SPRING_SECURITY_JWT_REQUEST_HEADER_JWT_MODE_VALUE_WEB = "web";
    public static final String SPRING_SECURITY_JWT_REQUEST_HEADER_JWT_MODE_VALUE_APP = "app";
    protected String jwtCookieParameterName = "JWT-TOKEN";
    protected String jwtRequestHeaderParameterName = "X-JWT-TOKEN";
    protected String jwtResponseHeaderParameterName = "JWT-TOKEN";
    protected String jwtModeRequestHeaderParameterName = "X-JWT-MODE";
    protected String xsrfCookieParameterName = "XSRF-TOKEN";
    protected String xsrfResponseHeaderParameterName = "XSRF-TOKEN";
    protected String xsrfRequestHeaderParameterName = "X-XSRF-TOKEN";
    protected String cookiePath = "/";
    protected boolean secureCookie = false;

    public TokenContainer getTokenFromRequest(HttpServletRequest request) {
        String jwtToken = this.getJWTTokenFromRequest(request);
        if (jwtToken == null || jwtToken.isEmpty()) {
            return null;
        }
        String xsrfToken = this.getXSRFTokenFromHeader(request);
        String jwtMode = this.getJWTModeFromHeader(request);
        return new TokenContainer(jwtMode, jwtToken, xsrfToken);
    }

    public Parameters getParametersFromRequest(HttpServletRequest request) {
        if (this.isJWTRequestedInAppMode(request)) {
            return new Parameters(new DisableXSRFParameter(true));
        }
        return null;
    }

    public void putTokenToResponse(HttpServletRequest request, HttpServletResponse response, TokenContainer tokenContainer) {
        String jwtToken = tokenContainer.getJwtToken();
        if (this.isJWTRequestedInAppMode(request)) {
            response.setHeader(this.jwtResponseHeaderParameterName, jwtToken);
        } else {
            Cookie jwtTokenCookie = new Cookie(this.jwtCookieParameterName, jwtToken);
            jwtTokenCookie.setHttpOnly(true);
            jwtTokenCookie.setSecure(this.secureCookie);
            jwtTokenCookie.setPath(this.cookiePath);
            String xsrfToken = tokenContainer.getXsrfToken();
            Cookie xsrfTokenCookie = new Cookie(this.xsrfCookieParameterName, xsrfToken);
            xsrfTokenCookie.setSecure(this.secureCookie);
            xsrfTokenCookie.setPath(this.cookiePath);
            response.setHeader(this.xsrfResponseHeaderParameterName, xsrfToken);
            response.addCookie(jwtTokenCookie);
            response.addCookie(xsrfTokenCookie);
        }
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public boolean isSecureCookie() {
        return this.secureCookie;
    }

    public void setSecureCookie(boolean secureCookie) {
        this.secureCookie = secureCookie;
    }

    public String getJwtCookieParameterName() {
        return this.jwtCookieParameterName;
    }

    public void setJwtCookieParameterName(String jwtCookieParameterName) {
        this.jwtCookieParameterName = jwtCookieParameterName;
    }

    public String getJwtRequestHeaderParameterName() {
        return this.jwtRequestHeaderParameterName;
    }

    public void setJwtRequestHeaderParameterName(String jwtRequestHeaderParameterName) {
        this.jwtRequestHeaderParameterName = jwtRequestHeaderParameterName;
    }

    public String getJwtResponseHeaderParameterName() {
        return this.jwtResponseHeaderParameterName;
    }

    public void setJwtResponseHeaderParameterName(String jwtResponseHeaderParameterName) {
        this.jwtResponseHeaderParameterName = jwtResponseHeaderParameterName;
    }

    public String getJwtModeRequestHeaderParameterName() {
        return this.jwtModeRequestHeaderParameterName;
    }

    public void setJwtModeRequestHeaderParameterName(String jwtModeRequestHeaderParameterName) {
        this.jwtModeRequestHeaderParameterName = jwtModeRequestHeaderParameterName;
    }

    public String getXsrfCookieParameterName() {
        return this.xsrfCookieParameterName;
    }

    public void setXsrfCookieParameterName(String xsrfCookieParameterName) {
        this.xsrfCookieParameterName = xsrfCookieParameterName;
    }

    public String getXsrfResponseHeaderParameterName() {
        return this.xsrfResponseHeaderParameterName;
    }

    public void setXsrfResponseHeaderParameterName(String xsrfResponseHeaderParameterName) {
        this.xsrfResponseHeaderParameterName = xsrfResponseHeaderParameterName;
    }

    public String getXsrfRequestHeaderParameterName() {
        return this.xsrfRequestHeaderParameterName;
    }

    public void setXsrfRequestHeaderParameterName(String xsrfRequestHeaderParameterName) {
        this.xsrfRequestHeaderParameterName = xsrfRequestHeaderParameterName;
    }

    protected String getJWTTokenFromRequest(HttpServletRequest request) {
        String jwtToken = null;
        jwtToken = this.isJWTRequestedInAppMode(request) ? this.getJWTTokenFromHeader(request) : this.getJWTTokenFromCookie(request);
        return jwtToken;
    }

    protected String getJWTTokenFromCookie(HttpServletRequest request) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.jwtCookieParameterName);
        if (cookie != null && cookie.getValue() != null) {
            return cookie.getValue();
        }
        return null;
    }

    protected String getJWTTokenFromHeader(HttpServletRequest request) {
        return request.getHeader(this.jwtRequestHeaderParameterName);
    }

    protected String getXSRFTokenFromHeader(HttpServletRequest request) {
        return request.getHeader(this.xsrfRequestHeaderParameterName);
    }

    protected String getJWTModeFromHeader(HttpServletRequest request) {
        String jwtMode = request.getHeader(this.jwtModeRequestHeaderParameterName);
        if (SPRING_SECURITY_JWT_REQUEST_HEADER_JWT_MODE_VALUE_APP.equals(jwtMode)) {
            return jwtMode;
        }
        return SPRING_SECURITY_JWT_REQUEST_HEADER_JWT_MODE_VALUE_WEB;
    }

    protected boolean isJWTRequestedInAppMode(HttpServletRequest request) {
        String jwtMode = this.getJWTModeFromHeader(request);
        return this.istJWTInAppMode(jwtMode);
    }

    protected boolean istJWTInAppMode(String jwtMode) {
        return SPRING_SECURITY_JWT_REQUEST_HEADER_JWT_MODE_VALUE_APP.equals(jwtMode);
    }
}

