/*
 * Decompiled with CFR 0.152.
 */
package software.reliabletx.camel.jms;

import java.security.SecureRandom;
import java.util.Random;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.JmsEndpoint;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import software.reliabletx.spring.ManagedSpringTransaction;
import software.reliabletx.spring.ManagedSpringTransactionImpl;

public class EnhancedDefaultJmsMessageListenerContainer
extends DefaultJmsMessageListenerContainer {
    private String transactionName;
    private int transactionTimeout;
    private boolean appendRandomToTxName = true;
    private Random random;
    private ThreadLocal<ManagedSpringTransaction> currentManagedTransaction = new ThreadLocal();

    public EnhancedDefaultJmsMessageListenerContainer(JmsEndpoint endpoint, boolean allowQuickStop) {
        super(endpoint, allowQuickStop);
    }

    public EnhancedDefaultJmsMessageListenerContainer(JmsEndpoint endpoint) {
        super(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean receiveAndExecute(Object invoker, Session session, MessageConsumer consumer) throws JMSException {
        if (this.getTransactionManager() != null) {
            ManagedSpringTransaction managedTx = this.establishTransaction();
            try {
                boolean messageReceived;
                try {
                    messageReceived = this.doReceiveAndExecute(invoker, session, consumer, managedTx.getTransactionStatus());
                }
                catch (JMSException ex) {
                    this.rollbackOnException(managedTx, ex);
                    throw ex;
                }
                catch (RuntimeException ex) {
                    this.rollbackOnException(managedTx, ex);
                    throw ex;
                }
                catch (Error err) {
                    this.rollbackOnException(managedTx, err);
                    throw err;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("receiveAndExecute(): about to commit " + managedTx.getTransactionName()));
                }
                managedTx.commit();
                if (!managedTx.isCommitted()) {
                    throw new RuntimeException("Something went wrong trying to commit the managed transaction " + managedTx.getTransactionName());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("receiveAndExecute(): committed " + managedTx.getTransactionName()));
                }
                boolean bl = messageReceived;
                return bl;
            }
            finally {
                this.deassociateCurrentManagedTransaction();
            }
        }
        return this.doReceiveAndExecute(invoker, session, consumer, null);
    }

    public void setTransactionName(String transactionName) {
        super.setTransactionName(transactionName);
        this.transactionName = transactionName;
    }

    protected String getTransactionName() {
        return this.transactionName;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        super.setTransactionTimeout(transactionTimeout);
        this.transactionTimeout = transactionTimeout;
    }

    protected int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void initialize() {
        super.initialize();
        if (this.transactionName == null) {
            this.transactionName = this.getBeanName();
        }
        if (this.isAppendingRandomToTxName()) {
            this.random = new Random(new SecureRandom().nextLong());
        }
    }

    protected void rollbackOnException(ManagedSpringTransaction managedTx, Throwable ex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Initiating transaction rollback on listener exception", ex);
        }
        try {
            managedTx.rollback();
        }
        catch (RuntimeException ex2) {
            this.logger.error((Object)"Listener exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error((Object)"Listener exception overridden by rollback error", ex);
            throw err;
        }
    }

    protected ManagedSpringTransaction establishTransaction() {
        ManagedSpringTransactionImpl managedTx = (ManagedSpringTransactionImpl)ManagedSpringTransactionImpl.getCurrentManagedSpringTransaction();
        if (managedTx == null || !managedTx.isCurrentAndActive()) {
            managedTx = new ManagedSpringTransactionImpl(this.getTransactionManager(), this.isAppendingRandomToTxName() ? this.getTransactionName() + "#" + this.nextRandom() : this.getTransactionName());
            if (managedTx.getTransactionDefinition() instanceof DefaultTransactionDefinition) {
                ((DefaultTransactionDefinition)managedTx.getTransactionDefinition()).setTimeout(this.getTransactionTimeout());
            }
            managedTx.beginTransaction();
            if (!managedTx.isCurrentAndActive()) {
                throw new RuntimeException("Something went wrong trying to establish a new managed transaction for " + managedTx.getTransactionName() + ": the new transaction is not current nor active");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("establishTransaction() there wasn't an already current and active managed transaction so established a new transaction: " + managedTx.getTransactionName()));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("establishTransaction(): keeping an already current and active managed transaction: " + managedTx.getTransactionName()));
        }
        this.currentManagedTransaction.set((ManagedSpringTransaction)managedTx);
        return managedTx;
    }

    protected void deassociateCurrentManagedTransaction() {
        this.currentManagedTransaction.remove();
    }

    public ManagedSpringTransaction getCurrentManagedTransaction() {
        return this.currentManagedTransaction.get();
    }

    protected boolean isAppendingRandomToTxName() {
        return this.appendRandomToTxName;
    }

    protected void setAppendingRandomToTxName(boolean appendRandomToTxName) {
        this.appendRandomToTxName = appendRandomToTxName;
    }

    protected int nextRandom() {
        return this.random.nextInt(Integer.MAX_VALUE);
    }
}

