/*
 * Decompiled with CFR 0.152.
 */
package software.pando.crypto.nacl;

import software.pando.crypto.nacl.HSalsa20;
import software.pando.crypto.nacl.Salsa20Poly1305;

final class XSalsa20Poly1305 {
    static final String ALGORITHM = "XSalsa20-Poly1305";
    static final int KEY_SIZE = 32;
    static final int NONCE_LEN = 24;
    static final int TAG_OFFSET = 16;
    static final int TAG_SIZE = 16;

    XSalsa20Poly1305() {
    }

    static byte[] encrypt(byte[] key, byte[] nonce, byte[] plaintext) {
        assert (key.length == 32);
        assert (nonce.length == 24);
        byte[] subKey = HSalsa20.apply(key, nonce);
        byte[] subNonce = new byte[12];
        System.arraycopy(nonce, 16, subNonce, 0, 8);
        return Salsa20Poly1305.encrypt(subKey, subNonce, plaintext);
    }

    static byte[] decrypt(byte[] key, byte[] nonce, byte[] plaintext) {
        assert (key.length == 32);
        assert (nonce.length == 24);
        byte[] subKey = HSalsa20.apply(key, nonce);
        byte[] subNonce = new byte[12];
        System.arraycopy(nonce, 16, subNonce, 0, 8);
        return Salsa20Poly1305.decrypt(subKey, subNonce, plaintext);
    }
}

