/*
 * Decompiled with CFR 0.152.
 */
package software.pando.crypto.nacl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.SecretKey;
import software.pando.crypto.nacl.Bytes;
import software.pando.crypto.nacl.CryptoSecretKey;
import software.pando.crypto.nacl.XSalsa20Poly1305;

public final class SecretBox
implements AutoCloseable {
    private static final Base64.Encoder base64urlEncoder = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder base64urlDecoder = Base64.getUrlDecoder();
    final byte[] nonce;
    final byte[] ciphertext;

    public static SecretKey key() {
        return SecretBox.key(Bytes.secureRandom(32));
    }

    public static SecretKey key(byte[] key) {
        if (key == null || key.length != 32) {
            throw new IllegalArgumentException("invalid key");
        }
        try {
            CryptoSecretKey cryptoSecretKey = new CryptoSecretKey(key, "XSalsa20-Poly1305");
            return cryptoSecretKey;
        }
        finally {
            Arrays.fill(key, (byte)0);
        }
    }

    public static SecretBox encrypt(Key key, byte[] nonce, byte[] message) {
        if (key == null || !"XSalsa20-Poly1305".equals(key.getAlgorithm()) || key.getEncoded() == null || key.getEncoded().length != 32) {
            throw new IllegalArgumentException("invalid key");
        }
        if (nonce == null || nonce.length != 24) {
            throw new IllegalArgumentException("invalid nonce");
        }
        if (message == null) {
            throw new NullPointerException("invalid message");
        }
        return SecretBox.encrypt(key.getEncoded(), nonce, message);
    }

    static SecretBox encrypt(byte[] key, byte[] nonce, byte[] message) {
        return new SecretBox(nonce, XSalsa20Poly1305.encrypt(key, nonce, message));
    }

    public static SecretBox encrypt(Key key, byte[] message) {
        return SecretBox.encrypt(key, Bytes.secureRandom(24), message);
    }

    public static SecretBox encrypt(Key key, String message) {
        return SecretBox.encrypt(key, message.getBytes(StandardCharsets.UTF_8));
    }

    SecretBox(byte[] nonce, byte[] ciphertext) {
        if (nonce == null || nonce.length != 24) {
            throw new IllegalArgumentException("invalid nonce");
        }
        if (ciphertext == null) {
            throw new NullPointerException("invalid ciphertext");
        }
        this.nonce = nonce;
        this.ciphertext = ciphertext;
    }

    public static SecretBox fromCombined(byte[] nonce, byte[] ciphertextWithTag) {
        byte[] ciphertext = new byte[ciphertextWithTag.length + 16];
        System.arraycopy(ciphertextWithTag, 0, ciphertext, 16, ciphertextWithTag.length);
        return new SecretBox(nonce, ciphertext);
    }

    public static SecretBox fromDetached(byte[] nonce, byte[] ciphertext, byte[] tag) {
        byte[] combined = new byte[ciphertext.length + tag.length + 16];
        System.arraycopy(tag, 0, combined, 16, tag.length);
        System.arraycopy(ciphertext, 0, combined, 16 + tag.length, ciphertext.length);
        return new SecretBox(nonce, combined);
    }

    public byte[] decrypt(Key key) {
        if (key == null || !"XSalsa20-Poly1305".equals(key.getAlgorithm()) || key.getEncoded() == null || key.getEncoded().length != 32) {
            throw new IllegalArgumentException("invalid key");
        }
        return this.decrypt(key.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] decrypt(byte[] key) {
        byte[] temp = (byte[])this.ciphertext.clone();
        try {
            byte[] byArray = XSalsa20Poly1305.decrypt(key, this.nonce, temp);
            return byArray;
        }
        finally {
            Arrays.fill(temp, (byte)0);
        }
    }

    public String decryptToString(Key key) {
        return new String(this.decrypt(key), StandardCharsets.UTF_8);
    }

    public byte[] getTag() {
        return Arrays.copyOfRange(this.ciphertext, 16, 32);
    }

    public byte[] getNonce() {
        return (byte[])this.nonce.clone();
    }

    public byte[] getCiphertextWithTag() {
        return Arrays.copyOfRange(this.ciphertext, 16, this.ciphertext.length);
    }

    public byte[] getCiphertextWithoutTag() {
        return Arrays.copyOfRange(this.ciphertext, 32, this.ciphertext.length);
    }

    public int writeTo(OutputStream out) throws IOException {
        out.write(this.nonce);
        byte[] len = new byte[4];
        ByteBuffer.wrap(len).order(ByteOrder.LITTLE_ENDIAN).putInt(this.ciphertext.length - 16);
        out.write(len);
        out.write(this.ciphertext, 16, this.ciphertext.length - 16);
        return this.nonce.length + this.ciphertext.length + 4;
    }

    public static SecretBox readFrom(InputStream in) throws IOException {
        byte[] nonce = in.readNBytes(24);
        byte[] lenBytes = in.readNBytes(4);
        int len = ByteBuffer.wrap(lenBytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
        if (len < 0) {
            throw new IOException("invalid ciphertext length");
        }
        byte[] ciphertext = new byte[len + 16];
        int read = in.readNBytes(ciphertext, 16, len);
        if (read != len) {
            throw new IOException("short read");
        }
        return new SecretBox(nonce, ciphertext);
    }

    public static SecretBox fromString(String encoded) {
        SecretBox secretBox;
        ByteArrayInputStream in = new ByteArrayInputStream(base64urlDecoder.decode(encoded));
        try {
            secretBox = SecretBox.readFrom(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AssertionError("Unexpected IOException while reading string", e);
            }
        }
        in.close();
        return secretBox;
    }

    public String toString() {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeTo(out);
            out.flush();
            string = base64urlEncoder.encodeToString(out.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AssertionError("Unexpected IOException writing string", e);
            }
        }
        out.close();
        return string;
    }

    @Override
    public void close() {
        Arrays.fill(this.ciphertext, (byte)0);
        Arrays.fill(this.nonce, (byte)0);
    }
}

