/*
 * Decompiled with CFR 0.152.
 */
package software.pando.crypto.nacl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

final class Salsa20 {
    private static final int STATE_LEN = 16;

    Salsa20() {
    }

    static void quarterRound(int[] state, int a, int b, int c, int d) {
        int n = b;
        state[n] = state[n] ^ Integer.rotateLeft(state[a] + state[d], 7);
        int n2 = c;
        state[n2] = state[n2] ^ Integer.rotateLeft(state[b] + state[a], 9);
        int n3 = d;
        state[n3] = state[n3] ^ Integer.rotateLeft(state[c] + state[b], 13);
        int n4 = a;
        state[n4] = state[n4] ^ Integer.rotateLeft(state[d] + state[c], 18);
    }

    static void rounds(int[] state) {
        assert (state.length == 16);
        for (int i = 0; i < 10; ++i) {
            Salsa20.quarterRound(state, 0, 4, 8, 12);
            Salsa20.quarterRound(state, 5, 9, 13, 1);
            Salsa20.quarterRound(state, 10, 14, 2, 6);
            Salsa20.quarterRound(state, 15, 3, 7, 11);
            Salsa20.quarterRound(state, 0, 1, 2, 3);
            Salsa20.quarterRound(state, 5, 6, 7, 4);
            Salsa20.quarterRound(state, 10, 11, 8, 9);
            Salsa20.quarterRound(state, 15, 12, 13, 14);
        }
    }

    static int[] blockFunction(int[] state) {
        assert (state.length == 16);
        int[] x = Arrays.copyOf(state, state.length);
        Salsa20.rounds(x);
        for (int i = 0; i < 16; ++i) {
            int n = i;
            x[n] = x[n] + state[i];
        }
        return x;
    }

    private static byte[] bytes(int[] block) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(block.length * 4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asIntBuffer().put(block);
        return byteBuffer.array();
    }

    static void encrypt(byte[] key, byte[] nonce, byte[] plaintext) {
        assert (key.length == 32);
        assert (nonce.length >= 8);
        if (nonce.length < 16) {
            byte[] newNonce = new byte[16];
            System.arraycopy(nonce, 0, newNonce, 0, nonce.length);
            nonce = newNonce;
        }
        int[] state = Salsa20.initialState(key, nonce);
        int numBlocks = plaintext.length + 63 >>> 6;
        for (int block = 0; block < numBlocks; ++block) {
            state[8] = block;
            byte[] keystream = Salsa20.bytes(Salsa20.blockFunction(state));
            int start = block * 64;
            int end = Math.min(start + 64, plaintext.length);
            for (int i = start; i < end; ++i) {
                int n = i;
                plaintext[n] = (byte)(plaintext[n] ^ keystream[i - start]);
            }
            Arrays.fill(keystream, (byte)0);
        }
    }

    static void decrypt(byte[] key, byte[] nonce, byte[] ciphertext) {
        Salsa20.encrypt(key, nonce, ciphertext);
    }

    static int[] initialState(byte[] key, byte[] nonce) {
        assert (key.length == 32);
        assert (nonce.length >= 16);
        int[] state = new int[16];
        state[0] = 1634760805;
        state[5] = 857760878;
        state[10] = 2036477234;
        state[15] = 1797285236;
        ByteBuffer buf = ByteBuffer.wrap(key).order(ByteOrder.LITTLE_ENDIAN);
        state[1] = buf.getInt();
        state[2] = buf.getInt();
        state[3] = buf.getInt();
        state[4] = buf.getInt();
        state[11] = buf.getInt();
        state[12] = buf.getInt();
        state[13] = buf.getInt();
        state[14] = buf.getInt();
        buf = ByteBuffer.wrap(nonce).order(ByteOrder.LITTLE_ENDIAN);
        state[6] = buf.getInt();
        state[7] = buf.getInt();
        state[8] = buf.getInt();
        state[9] = buf.getInt();
        return state;
    }
}

