/*
 * Decompiled with CFR 0.152.
 */
package software.pando.crypto.nacl;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;

final class SHA512 {
    private static final String HASH_ALGORITHM = "SHA-512";
    static final String MAC_ALGORITHM = "HmacSHA512";
    static final int HASH_LEN = 64;
    static final int HMAC_KEY_LEN = 32;
    static final int TAG_LEN = 32;

    SHA512() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] hash(byte[] data, int len) {
        if (len <= 0 || len > 64) {
            throw new IllegalArgumentException("len must be in range 1..64");
        }
        byte[] digest = null;
        try {
            MessageDigest sha512 = SHA512.getDigest();
            digest = sha512.digest(data);
            byte[] byArray = Arrays.copyOf(digest, len);
            return byArray;
        }
        finally {
            if (digest != null) {
                Arrays.fill(digest, (byte)0);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] hmac(Key key, byte[] data, int len) {
        byte[] byArray;
        block7: {
            if (len <= 0 || len > 64) {
                throw new IllegalArgumentException("len must be in range 1..64");
            }
            byte[] mac = null;
            try {
                Mac hmac = Mac.getInstance(MAC_ALGORITHM);
                hmac.init(key);
                mac = hmac.doFinal(data);
                byArray = Arrays.copyOf(mac, len);
                if (mac == null) break block7;
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    throw new IllegalStateException(e);
                    catch (InvalidKeyException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (mac != null) {
                        Arrays.fill(mac, (byte)0);
                    }
                    throw throwable;
                }
            }
            Arrays.fill(mac, (byte)0);
        }
        return byArray;
    }

    static MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance(HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("JVM does not support SHA-512", e);
        }
    }
}

