/*
 * Decompiled with CFR 0.152.
 */
package software.pando.crypto.nacl;

import java.util.Arrays;
import javax.crypto.SecretKey;

final class CryptoSecretKey
implements SecretKey {
    private final byte[] keyMaterial;
    private final String algorithm;

    CryptoSecretKey(byte[] keyMaterial, String algorithm) {
        this.keyMaterial = (byte[])keyMaterial.clone();
        this.algorithm = algorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.keyMaterial.clone();
    }

    @Override
    public void destroy() {
        Arrays.fill(this.keyMaterial, (byte)0);
    }

    @Override
    public boolean isDestroyed() {
        int x = 0;
        for (byte b : this.keyMaterial) {
            x |= b;
        }
        return x == 0;
    }
}

