/*
 * Decompiled with CFR 0.152.
 */
package software.pando.crypto.nacl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.NamedParameterSpec;
import java.security.spec.XECPrivateKeySpec;
import java.security.spec.XECPublicKeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import software.pando.crypto.nacl.Bytes;
import software.pando.crypto.nacl.HSalsa20;
import software.pando.crypto.nacl.SHA512;
import software.pando.crypto.nacl.SecretBox;

public final class CryptoBox
implements AutoCloseable {
    private static final String KEY_AGREEMENT_ALGORITHM = "X25519";
    private static final AlgorithmParameterSpec X25519_PARAMS = new NamedParameterSpec("X25519");
    private static final byte[] ZERO = new byte[16];
    private final SecretBox box;

    public static KeyPair keyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_AGREEMENT_ALGORITHM);
            keyPairGenerator.initialize(X25519_PARAMS);
            return keyPairGenerator.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to generate key pair", e);
        }
    }

    public static KeyPair seedKeyPair(byte[] seed) {
        if (seed == null || seed.length != 32) {
            throw new IllegalArgumentException("invalid seed: must be exactly 32 bytes");
        }
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_AGREEMENT_ALGORITHM);
            keyPairGenerator.initialize(X25519_PARAMS, CryptoBox.seedSecureRandom(seed));
            return keyPairGenerator.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to generate key pair", e);
        }
    }

    private static SecureRandom seedSecureRandom(byte[] seed) {
        return new SecureRandom(new SeedSecureRandom(seed), null){};
    }

    public static PublicKey publicKey(byte[] publicKeyBytes) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_AGREEMENT_ALGORITHM);
            BigInteger u = new BigInteger(Bytes.reverse(publicKeyBytes));
            return keyFactory.generatePublic(new XECPublicKeySpec(X25519_PARAMS, u));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("Unable to generate public key", e);
        }
    }

    public static PrivateKey privateKey(byte[] privateKeyBytes) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_AGREEMENT_ALGORITHM);
            return keyFactory.generatePrivate(new XECPrivateKeySpec(X25519_PARAMS, privateKeyBytes));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("Unable to generate private key", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoBox encrypt(PrivateKey ourPrivateKey, PublicKey theirPublicKey, byte[] nonce, byte[] plaintext) {
        if (nonce.length != 24) {
            throw new IllegalArgumentException("nonce must be 24 bytes");
        }
        byte[] key = CryptoBox.agreeKey(ourPrivateKey, theirPublicKey);
        try {
            CryptoBox cryptoBox = new CryptoBox(SecretBox.encrypt(key, nonce, plaintext));
            return cryptoBox;
        }
        finally {
            Arrays.fill(key, (byte)0);
        }
    }

    public static CryptoBox encrypt(PrivateKey ourPrivateKey, PublicKey theirPublicKey, byte[] plaintext) {
        byte[] nonce = Bytes.secureRandom(24);
        return CryptoBox.encrypt(ourPrivateKey, theirPublicKey, nonce, plaintext);
    }

    public static CryptoBox encrypt(PrivateKey ourPrivateKey, PublicKey theirPublicKey, String plaintext) {
        return CryptoBox.encrypt(ourPrivateKey, theirPublicKey, plaintext.getBytes(StandardCharsets.UTF_8));
    }

    public static Key agree(PrivateKey ourPrivateKey, PublicKey theirPublicKey) {
        return SecretBox.key(CryptoBox.agreeKey(ourPrivateKey, theirPublicKey));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] agreeKey(PrivateKey ourPrivateKey, PublicKey theirPublicKey) {
        byte[] byArray;
        block6: {
            byte[] sharedSecret = null;
            try {
                KeyAgreement x25519 = KeyAgreement.getInstance(KEY_AGREEMENT_ALGORITHM);
                x25519.init(ourPrivateKey);
                x25519.doPhase(theirPublicKey, true);
                sharedSecret = x25519.generateSecret();
                byArray = HSalsa20.apply(sharedSecret, ZERO);
                if (sharedSecret == null) break block6;
            }
            catch (InvalidKeyException e) {
                try {
                    throw new IllegalArgumentException(e);
                    catch (NoSuchAlgorithmException e2) {
                        throw new IllegalStateException("X25519 not supported", e2);
                    }
                }
                catch (Throwable throwable) {
                    if (sharedSecret != null) {
                        Arrays.fill(sharedSecret, (byte)0);
                    }
                    throw throwable;
                }
            }
            Arrays.fill(sharedSecret, (byte)0);
        }
        return byArray;
    }

    private CryptoBox(SecretBox box) {
        this.box = box;
    }

    public static CryptoBox fromCombined(byte[] nonce, byte[] ciphertextWithTag) {
        SecretBox secretBox = SecretBox.fromCombined(nonce, ciphertextWithTag);
        return new CryptoBox(secretBox);
    }

    public static CryptoBox fromDetached(byte[] nonce, byte[] ciphertext, byte[] tag) {
        SecretBox secretBox = SecretBox.fromDetached(nonce, ciphertext, tag);
        return new CryptoBox(secretBox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(PrivateKey ourPrivateKey, PublicKey sender) {
        byte[] key = CryptoBox.agreeKey(ourPrivateKey, sender);
        try {
            byte[] byArray = this.box.decrypt(key);
            return byArray;
        }
        finally {
            Arrays.fill(key, (byte)0);
        }
    }

    public String decryptToString(PrivateKey ourPrivateKey, PublicKey sender) {
        return new String(this.decrypt(ourPrivateKey, sender), StandardCharsets.UTF_8);
    }

    public byte[] getTag() {
        return this.box.getTag();
    }

    public byte[] getNonce() {
        return this.box.getNonce();
    }

    public byte[] getCiphertextWithTag() {
        return this.box.getCiphertextWithTag();
    }

    public byte[] getCiphertextWithoutTag() {
        return this.box.getCiphertextWithoutTag();
    }

    public int writeTo(OutputStream out) throws IOException {
        return this.box.writeTo(out);
    }

    public static CryptoBox readFrom(InputStream in) throws IOException {
        SecretBox secretBox = SecretBox.readFrom(in);
        return new CryptoBox(secretBox);
    }

    public static CryptoBox fromString(String encoded) {
        SecretBox secretBox = SecretBox.fromString(encoded);
        return new CryptoBox(secretBox);
    }

    public String toString() {
        return this.box.toString();
    }

    @Override
    public void close() {
        this.box.close();
    }

    private static class SeedSecureRandom
    extends SecureRandomSpi {
        private byte[] seed;

        SeedSecureRandom(byte[] seed) {
            this.seed = seed;
        }

        @Override
        protected void engineSetSeed(byte[] seed) {
        }

        @Override
        protected synchronized void engineNextBytes(byte[] bytes) {
            if (this.seed == null) {
                throw new IllegalStateException("seed data exhausted");
            }
            byte[] data = SHA512.hash(this.seed, bytes.length);
            System.arraycopy(data, 0, bytes, 0, bytes.length);
            Arrays.fill(data, (byte)0);
            Arrays.fill(this.seed, (byte)0);
            this.seed = null;
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            throw new UnsupportedOperationException();
        }
    }
}

