/*
 * Decompiled with CFR 0.152.
 */
package software.pando.crypto.nacl;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.SecretKey;
import software.pando.crypto.nacl.Bytes;
import software.pando.crypto.nacl.CryptoBox;
import software.pando.crypto.nacl.CryptoSecretKey;
import software.pando.crypto.nacl.Ed25519;
import software.pando.crypto.nacl.SHA512;
import software.pando.crypto.nacl.SecretBox;

public final class Crypto {
    public static CryptoBox box(PrivateKey privateKey, PublicKey publicKey, byte[] plaintext) {
        return CryptoBox.encrypt(privateKey, publicKey, plaintext);
    }

    public static SecretBox box(SecretKey key, byte[] plaintext) {
        return SecretBox.encrypt((Key)key, plaintext);
    }

    public static byte[] hash(byte[] data) {
        return SHA512.hash(data, 64);
    }

    public static SecretKey authKeyGen() {
        return new CryptoSecretKey(Bytes.secureRandom(32), "HmacSHA512");
    }

    public static SecretKey authKey(byte[] keyBytes) {
        if (keyBytes.length != 32) {
            throw new IllegalArgumentException("invalid key");
        }
        return new CryptoSecretKey(keyBytes, "HmacSHA512");
    }

    public static byte[] auth(SecretKey authKey, byte[] message) {
        return SHA512.hmac(authKey, message, 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean authVerify(SecretKey authKey, byte[] message, byte[] tag) {
        byte[] computed = Crypto.auth(authKey, message);
        try {
            boolean bl = Bytes.equal(computed, tag);
            return bl;
        }
        finally {
            Arrays.fill(computed, (byte)0);
        }
    }

    public static KeyPair signingKeyPair() {
        return Crypto.seedSigningKeyPair(Bytes.secureRandom(32));
    }

    public static KeyPair seedSigningKeyPair(byte[] seed) {
        if (seed.length != 32) {
            throw new IllegalArgumentException("seed must be exactly 32 bytes");
        }
        Ed25519.PrivateKey privateKey = new Ed25519.PrivateKey(seed);
        return new KeyPair(new Ed25519.PublicKey(privateKey.getPublicKey()), privateKey);
    }

    public static PrivateKey signingPrivateKey(byte[] bytes) {
        return new Ed25519.PrivateKey(bytes);
    }

    public static PublicKey signingPublicKey(byte[] bytes) {
        return new Ed25519.PublicKey(bytes);
    }

    public static byte[] sign(PrivateKey privateKey, byte[] data) {
        if (!(privateKey instanceof Ed25519.PrivateKey)) {
            throw new IllegalArgumentException("invalid Ed25519 private key");
        }
        byte[] hashedPrivateKey = ((Ed25519.PrivateKey)privateKey).getHashedScalar();
        byte[] publicKey = ((Ed25519.PrivateKey)privateKey).getPublicKey();
        return Ed25519.sign(data, publicKey, hashedPrivateKey);
    }

    public static boolean signVerify(PublicKey publicKey, byte[] data, byte[] signature) {
        if (!(publicKey instanceof Ed25519.PublicKey)) {
            throw new IllegalArgumentException("invalid Ed25519 public key");
        }
        return Ed25519.verify(data, signature, ((Ed25519.PublicKey)publicKey).getKeyBytes());
    }
}

