/*
 * Decompiled with CFR 0.152.
 */
package software.pando.crypto.nacl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;

public final class Bytes {
    private static final SecureRandom SECURE_RANDOM_SOURCE = Bytes.getSecureRandomInstance();

    public static boolean equal(byte[] a, byte[] b) {
        return MessageDigest.isEqual(a, b);
    }

    public static byte[] secureRandom(int numBytes) {
        return SECURE_RANDOM_SOURCE.generateSeed(numBytes);
    }

    static byte[] reverse(byte[] bytes) {
        for (int i = 0; i < bytes.length >> 1; ++i) {
            Bytes.swap(bytes, i, bytes.length - i - 1);
        }
        return bytes;
    }

    static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    private static void swap(byte[] bytes, int x, int y) {
        assert (x != y);
        int n = x;
        bytes[n] = (byte)(bytes[n] ^ bytes[y]);
        int n2 = y;
        bytes[n2] = (byte)(bytes[n2] ^ bytes[x]);
        int n3 = x;
        bytes[n3] = (byte)(bytes[n3] ^ bytes[y]);
    }

    private static SecureRandom getSecureRandomInstance() {
        String[] PREFERRED_PRNGS;
        for (String alg : PREFERRED_PRNGS = new String[]{"NativePRNGNonBlocking", "NativePRNG", "DRBG"}) {
            try {
                return SecureRandom.getInstance(alg);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).startsWith("windows")) {
            try {
                return SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Unable to find a high-quality SecureRandom source");
    }
}

