/*
 * Decompiled with CFR 0.152.
 */
package momento.lock.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class MomentoLockItem {
    private final String partitionKey;
    private final String sortKey;
    private final String owner;
    private final long leaseDuration;
    private final ByteBuffer data;
    private final Map<String, AttributeValue> additionalData;

    @JsonCreator
    public MomentoLockItem(@JsonProperty(value="owner") String owner, @JsonProperty(value="leaseDuration") long leaseDuration, @JsonProperty(value="partitionKey") String partitionKey, @JsonProperty(value="sortKey") String sortKey, @JsonProperty(value="data") ByteBuffer data, @JsonProperty(value="additionalData") Map<String, AttributeValue> additionalData) {
        this.owner = owner;
        this.leaseDuration = leaseDuration;
        this.partitionKey = partitionKey;
        this.sortKey = sortKey;
        this.data = data;
        this.additionalData = additionalData;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getLeaseDuration() {
        return this.leaseDuration;
    }

    public Map<String, AttributeValue> getAdditionalData() {
        return this.additionalData;
    }

    @JsonIgnore
    public String getCacheKey() {
        String cacheKey = this.partitionKey;
        if (this.sortKey != null) {
            cacheKey = this.partitionKey + "_" + this.sortKey;
        }
        return cacheKey;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    @JsonIgnore
    public boolean getDeleteLockOnRelease() {
        return false;
    }

    @JsonIgnore
    public boolean isReleased() {
        return false;
    }
}

