/*
 * Decompiled with CFR 0.152.
 */
package momento.lock.client;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import momento.lock.client.LockItemUtils;
import momento.lock.client.MomentoLockItem;
import momento.lock.client.model.MomentoClientException;
import momento.sdk.CacheClient;
import momento.sdk.responses.cache.DeleteResponse;
import momento.sdk.responses.cache.GetResponse;
import momento.sdk.responses.cache.SetIfNotExistsResponse;
import momento.sdk.responses.cache.control.CacheCreateResponse;
import momento.sdk.responses.cache.control.CacheInfo;
import momento.sdk.responses.cache.control.CacheListResponse;
import momento.sdk.responses.cache.ttl.ItemGetTtlResponse;

public class MomentoLockClient {
    private final CacheClient client;
    private final String cacheName;
    private static final Duration MOMENTO_TIMEOUT = Duration.ofSeconds(10L);

    public MomentoLockClient(CacheClient client, String cacheName) {
        this.client = client;
        this.cacheName = cacheName;
    }

    public Optional<MomentoLockItem> getLockFromMomento(String cacheKey) {
        try {
            GetResponse getResponse = (GetResponse)this.client.get(this.cacheName, cacheKey).get(MOMENTO_TIMEOUT.getSeconds(), TimeUnit.SECONDS);
            if (getResponse instanceof GetResponse.Hit) {
                MomentoLockItem momentoLockItem = LockItemUtils.deserialize(((GetResponse.Hit)getResponse).valueByteArray());
                return Optional.of(momentoLockItem);
            }
        }
        catch (TimeoutException e) {
            throw new MomentoClientException("Exceeded client side timeout of 10 seconds while retrieving from Momento for cache key " + cacheKey);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MomentoClientException("Caught unexpected exception while retrieving from Momento for cache key " + cacheKey);
        }
        return Optional.empty();
    }

    public boolean acquireLockInMomento(MomentoLockItem lockItem) {
        try {
            SetIfNotExistsResponse response = (SetIfNotExistsResponse)this.client.setIfNotExists(this.cacheName, lockItem.getCacheKey(), LockItemUtils.serialize(lockItem)).get(MOMENTO_TIMEOUT.getSeconds(), TimeUnit.SECONDS);
            if (response instanceof SetIfNotExistsResponse.Stored) {
                return true;
            }
            if (response instanceof SetIfNotExistsResponse.Error) {
                throw new MomentoClientException(((SetIfNotExistsResponse.Error)response).getMessage(), ((SetIfNotExistsResponse.Error)response).getCause());
            }
        }
        catch (TimeoutException e) {
            throw new MomentoClientException("Exceeded client side timeout of 10 seconds while retrieving from Momento for cache key " + lockItem.getCacheKey());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MomentoClientException("Caught unexpected exception while retrieving from Momento for cache key " + lockItem.getCacheKey());
        }
        return false;
    }

    public boolean deleteLockFromMomento(MomentoLockItem lockItem) {
        try {
            DeleteResponse response = (DeleteResponse)this.client.delete(this.cacheName, lockItem.getCacheKey()).get(MOMENTO_TIMEOUT.getSeconds(), TimeUnit.SECONDS);
            if (response instanceof DeleteResponse.Success) {
                return true;
            }
            if (response instanceof DeleteResponse.Error) {
                throw new MomentoClientException(((DeleteResponse.Error)response).getMessage(), ((DeleteResponse.Error)response).getCause());
            }
        }
        catch (TimeoutException e) {
            throw new MomentoClientException("Exceeded client side timeout of 10 seconds while retrieving from Momento for cache key " + lockItem.getCacheKey());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MomentoClientException("Caught unexpected exception while retrieving from Momento for cache key " + lockItem.getCacheKey());
        }
        return false;
    }

    public Long getLockRemainingTtl(MomentoLockItem momentoLockItem) {
        try {
            ItemGetTtlResponse itemGetTtlResponse = (ItemGetTtlResponse)this.client.itemGetTtl(this.cacheName, momentoLockItem.getCacheKey()).get(MOMENTO_TIMEOUT.getSeconds(), TimeUnit.SECONDS);
            if (itemGetTtlResponse instanceof ItemGetTtlResponse.Hit) {
                return ((ItemGetTtlResponse.Hit)itemGetTtlResponse).remainingTtlMillis();
            }
            if (itemGetTtlResponse instanceof ItemGetTtlResponse.Error) {
                throw new MomentoClientException(((ItemGetTtlResponse.Error)itemGetTtlResponse).getMessage(), ((ItemGetTtlResponse.Error)itemGetTtlResponse).getCause());
            }
        }
        catch (TimeoutException e) {
            throw new MomentoClientException("Exceeded client side timeout of 10 seconds while retrieving from Momento for cache key " + momentoLockItem.getCacheKey());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MomentoClientException("Caught unexpected exception while retrieving from Momento for cache key " + momentoLockItem.getCacheKey());
        }
        return null;
    }

    public boolean createLockCache(String cacheName) {
        try {
            CacheCreateResponse createResponse = (CacheCreateResponse)this.client.createCache(cacheName).get(MOMENTO_TIMEOUT.getSeconds(), TimeUnit.SECONDS);
            if (createResponse instanceof CacheCreateResponse.Error) {
                return false;
            }
        }
        catch (TimeoutException e) {
            throw new MomentoClientException("Exceeded client side timeout of 10 seconds while creating cache in Momento for cache name " + cacheName);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MomentoClientException("Caught unexpected exception while while creating cache in Momento for cache name " + cacheName);
        }
        return true;
    }

    public boolean lockCacheExists(String cacheName) {
        try {
            CacheListResponse response = (CacheListResponse)this.client.listCaches().get(MOMENTO_TIMEOUT.getSeconds(), TimeUnit.SECONDS);
            if (response instanceof CacheListResponse.Success) {
                List cacheInfoList = ((CacheListResponse.Success)response).getCaches();
                return cacheInfoList.stream().map(CacheInfo::name).anyMatch(name -> name.equals(cacheName));
            }
            if (response instanceof CacheListResponse.Error) {
                throw new MomentoClientException(((CacheListResponse.Error)response).getMessage(), ((CacheListResponse.Error)response).getCause());
            }
        }
        catch (TimeoutException e) {
            throw new MomentoClientException("Exceeded client side timeout of 10 seconds while checking cache existence in Momento for cache name " + cacheName);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MomentoClientException("Caught unexpected exception while while checking cache existence in Momento for cache name " + cacheName);
        }
        return false;
    }
}

