/*
 * Decompiled with CFR 0.152.
 */
package momento.lock.client;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import momento.sdk.auth.CredentialProvider;
import momento.sdk.config.Configuration;

public class MomentoDynamoDBLockClientOptions {
    private final String cacheName;
    private final CredentialProvider credentialProvider;
    private final Configuration configuration;
    protected static final String DEFAULT_PARTITION_KEY_NAME = "key";
    protected static final Long DEFAULT_LEASE_DURATION = 20L;
    protected static final Integer DEFAULT_ACQUIRE_LOCKS_EXECUTOR_NUM_THREADS = 8;
    protected static final Long DEFAULT_HEARTBEAT_PERIOD = 5L;
    protected static final Integer DEFAULT_HEARTBEAT_EXECUTOR_NUM_THREADS = 1;
    protected static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    protected static final Boolean DEFAULT_CREATE_HEARTBEAT_BACKGROUND_THREAD = true;
    protected static final Boolean DEFAULT_HOLD_LOCK_ON_SERVICE_UNAVAILABLE = false;
    private final String tableName;
    private final String partitionKeyName;
    private final Optional<String> sortKeyName;
    private final String ownerName;
    private final Long leaseDuration;
    private final int totalNumThreadsForAcquiringLocks;
    private final Long heartbeatPeriod;
    private final TimeUnit timeUnit;
    private final Boolean createHeartbeatBackgroundThread;
    private final int totalNumBackgroundThreadsForHeartbeating;
    private final Function<String, ThreadFactory> namedThreadCreator;
    private final Boolean holdLockOnServiceUnavailable;

    private MomentoDynamoDBLockClientOptions(Configuration configuration, CredentialProvider credentialProvider, String tableName, String partitionKeyName, Optional<String> sortKeyName, String ownerName, Long leaseDuration, int totalNumBackgroundThreadsForHeartbeating, Long heartbeatPeriod, TimeUnit timeUnit, Boolean createHeartbeatBackgroundThread, int totalNumThreadsForAcquiringLocks, Function<String, ThreadFactory> namedThreadCreator, Boolean holdLockOnServiceUnavailable) {
        this.configuration = configuration;
        this.credentialProvider = credentialProvider;
        this.tableName = tableName;
        this.cacheName = tableName;
        this.partitionKeyName = partitionKeyName;
        this.sortKeyName = sortKeyName;
        this.ownerName = ownerName;
        this.leaseDuration = leaseDuration;
        this.totalNumThreadsForAcquiringLocks = totalNumThreadsForAcquiringLocks;
        this.heartbeatPeriod = heartbeatPeriod;
        this.timeUnit = timeUnit;
        this.createHeartbeatBackgroundThread = createHeartbeatBackgroundThread;
        this.totalNumBackgroundThreadsForHeartbeating = totalNumBackgroundThreadsForHeartbeating;
        this.namedThreadCreator = namedThreadCreator;
        this.holdLockOnServiceUnavailable = holdLockOnServiceUnavailable;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPartitionKeyName() {
        return this.partitionKeyName;
    }

    public Optional<String> getSortKeyName() {
        return this.sortKeyName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Long getLeaseDuration() {
        return this.leaseDuration;
    }

    public Long getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Boolean getCreateHeartbeatBackgroundThread() {
        return this.createHeartbeatBackgroundThread;
    }

    public Function<String, ThreadFactory> getNamedThreadCreator() {
        return this.namedThreadCreator;
    }

    public Boolean getHoldLockOnServiceUnavailable() {
        return this.holdLockOnServiceUnavailable;
    }

    public CredentialProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public int getTotalNumThreadsForAcquiringLocks() {
        return this.totalNumThreadsForAcquiringLocks;
    }

    public int getTotalNumBackgroundThreadsForHeartbeating() {
        return this.totalNumBackgroundThreadsForHeartbeating;
    }

    public static MomentoDynamoDBLockClientOptionsBuilder builder(String cacheName) {
        return new MomentoDynamoDBLockClientOptionsBuilder(cacheName);
    }

    public static class MomentoDynamoDBLockClientOptionsBuilder {
        private String tableName;
        private String partitionKeyName;
        private Optional<String> sortKeyName;
        private String ownerName;
        private Long leaseDuration;
        private int totalNumThreadsForAcquiringLocks;
        private Long heartbeatPeriod;
        private TimeUnit timeUnit;
        private Boolean createHeartbeatBackgroundThread;
        private int totalNumBackgroundThreadsForHeartbeating;
        private Boolean holdLockOnServiceUnavailable;
        private Function<String, ThreadFactory> namedThreadCreator;
        private Configuration configuration;
        private CredentialProvider credentialProvider;

        MomentoDynamoDBLockClientOptionsBuilder(String tableName) {
            this(tableName, MomentoDynamoDBLockClientOptionsBuilder.generateOwnerNameFromLocalhost(), MomentoDynamoDBLockClientOptionsBuilder.namedThreadCreator());
        }

        private static final String generateOwnerNameFromLocalhost() {
            try {
                return Inet4Address.getLocalHost().getHostName() + UUID.randomUUID().toString();
            }
            catch (UnknownHostException e) {
                return UUID.randomUUID().toString();
            }
        }

        private static Function<String, ThreadFactory> namedThreadCreator() {
            return threadName -> runnable -> new Thread(runnable, (String)threadName);
        }

        MomentoDynamoDBLockClientOptionsBuilder(String tableName, String ownerName, Function<String, ThreadFactory> namedThreadCreator) {
            this.tableName = tableName;
            this.partitionKeyName = MomentoDynamoDBLockClientOptions.DEFAULT_PARTITION_KEY_NAME;
            this.leaseDuration = DEFAULT_LEASE_DURATION;
            this.totalNumThreadsForAcquiringLocks = DEFAULT_ACQUIRE_LOCKS_EXECUTOR_NUM_THREADS;
            this.heartbeatPeriod = DEFAULT_HEARTBEAT_PERIOD;
            this.timeUnit = DEFAULT_TIME_UNIT;
            this.createHeartbeatBackgroundThread = DEFAULT_CREATE_HEARTBEAT_BACKGROUND_THREAD;
            this.totalNumBackgroundThreadsForHeartbeating = DEFAULT_HEARTBEAT_EXECUTOR_NUM_THREADS;
            this.sortKeyName = Optional.empty();
            this.ownerName = ownerName == null ? MomentoDynamoDBLockClientOptionsBuilder.generateOwnerNameFromLocalhost() : ownerName;
            this.namedThreadCreator = namedThreadCreator == null ? MomentoDynamoDBLockClientOptionsBuilder.namedThreadCreator() : namedThreadCreator;
            this.holdLockOnServiceUnavailable = DEFAULT_HOLD_LOCK_ON_SERVICE_UNAVAILABLE;
        }

        public MomentoDynamoDBLockClientOptionsBuilder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public MomentoDynamoDBLockClientOptionsBuilder withCredentialProvider(CredentialProvider credentialProvider) {
            this.credentialProvider = credentialProvider;
            return this;
        }

        public MomentoDynamoDBLockClientOptionsBuilder withTotalNumBackgroundThreadsForHeartbeating(int totalNumBackgroundThreadsForHeartbeating) {
            this.totalNumBackgroundThreadsForHeartbeating = totalNumBackgroundThreadsForHeartbeating;
            return this;
        }

        public MomentoDynamoDBLockClientOptionsBuilder withTotalNumThreadsForAcquiringLocks(int totalNumThreadsForAcquiringLocks) {
            this.totalNumThreadsForAcquiringLocks = totalNumThreadsForAcquiringLocks;
            return this;
        }

        public MomentoDynamoDBLockClientOptionsBuilder withPartitionKeyName(String partitionKeyName) {
            this.partitionKeyName = partitionKeyName;
            return this;
        }

        public MomentoDynamoDBLockClientOptionsBuilder withSortKeyName(String sortKeyName) {
            this.sortKeyName = Optional.of(sortKeyName);
            return this;
        }

        public MomentoDynamoDBLockClientOptionsBuilder withOwnerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public MomentoDynamoDBLockClientOptionsBuilder withLeaseDuration(Long leaseDuration) {
            this.leaseDuration = leaseDuration;
            return this;
        }

        public MomentoDynamoDBLockClientOptionsBuilder withHeartbeatPeriod(Long heartbeatPeriod) {
            this.heartbeatPeriod = heartbeatPeriod;
            return this;
        }

        public MomentoDynamoDBLockClientOptionsBuilder withTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public MomentoDynamoDBLockClientOptionsBuilder withCreateHeartbeatBackgroundThread(Boolean createHeartbeatBackgroundThread) {
            this.createHeartbeatBackgroundThread = createHeartbeatBackgroundThread;
            return this;
        }

        public MomentoDynamoDBLockClientOptionsBuilder withHoldLockOnServiceUnavailable(Boolean holdLockOnServiceUnavailable) {
            this.holdLockOnServiceUnavailable = holdLockOnServiceUnavailable;
            return this;
        }

        public MomentoDynamoDBLockClientOptions build() {
            return new MomentoDynamoDBLockClientOptions(this.configuration, this.credentialProvider, this.tableName, this.partitionKeyName, this.sortKeyName, this.ownerName, this.leaseDuration, this.totalNumThreadsForAcquiringLocks, this.heartbeatPeriod, this.timeUnit, this.createHeartbeatBackgroundThread, this.totalNumBackgroundThreadsForHeartbeating, this.namedThreadCreator, this.holdLockOnServiceUnavailable);
        }
    }
}

