/*
 * Decompiled with CFR 0.152.
 */
package momento.lock.client;

import com.amazonaws.services.dynamodbv2.LockItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LockStorage {
    private final ConcurrentHashMap<String, LockItem> locks = new ConcurrentHashMap();

    public boolean hasLock(String cacheKey) {
        LockItem lockItem = this.locks.get(cacheKey);
        return lockItem != null && !lockItem.isExpired();
    }

    public boolean removeLock(String cacheKey) {
        LockItem prev = this.locks.remove(cacheKey);
        return prev != null;
    }

    public Optional<LockItem> getLock(String cacheKey) {
        LockItem lockItem = this.locks.get(cacheKey);
        if (lockItem == null || lockItem.isExpired()) {
            return Optional.empty();
        }
        return Optional.of(lockItem);
    }

    public void addLock(String cacheKey, LockItem lockItem) {
        this.locks.put(cacheKey, lockItem);
    }

    public List<LockItem> getAllLocks() {
        return new ArrayList<LockItem>(this.locks.values());
    }
}

