/*
 * Decompiled with CFR 0.152.
 */
package momento.lock.client;

import com.amazonaws.services.dynamodbv2.LockItem;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import momento.lock.client.MomentoLockItem;

public class LockItemUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static byte[] serialize(MomentoLockItem lockItem) {
        try {
            return MAPPER.writeValueAsBytes((Object)lockItem);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(String.format("Failed to serialize lock item value %s", lockItem.toString()), e);
        }
    }

    public static MomentoLockItem deserialize(byte[] lockItemValueJSONString) {
        try {
            return (MomentoLockItem)MAPPER.readValue(lockItemValueJSONString, MomentoLockItem.class);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to deserialize lock item value %s", new Object[]{lockItemValueJSONString}), e);
        }
    }

    public static MomentoLockItem toMomentoLockItem(LockItem lockItem) {
        String sortKey = null;
        if (lockItem.getSortKey().isPresent()) {
            sortKey = (String)lockItem.getSortKey().get();
        }
        ByteBuffer data = lockItem.getData().isPresent() ? (ByteBuffer)lockItem.getData().get() : null;
        Map additionalData = lockItem.getAdditionalAttributes();
        MomentoLockItem momentoLockItem = new MomentoLockItem(lockItem.getOwnerName(), lockItem.getLeaseDuration(), lockItem.getPartitionKey(), sortKey, data, additionalData);
        return momentoLockItem;
    }
}

