/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.services.dynamodbv2.AcquireLockOptions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClientOptions;
import com.amazonaws.services.dynamodbv2.LockItem;
import com.amazonaws.services.dynamodbv2.ReleaseLockOptions;
import com.amazonaws.services.dynamodbv2.SendHeartbeatOptions;
import com.amazonaws.services.dynamodbv2.SessionMonitor;
import com.amazonaws.services.dynamodbv2.model.LockCurrentlyUnavailableException;
import com.amazonaws.services.dynamodbv2.model.LockNotGrantedException;
import com.amazonaws.services.dynamodbv2.util.LockClientUtils;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import momento.lock.client.LockItemUtils;
import momento.lock.client.LockStorage;
import momento.lock.client.MomentoDynamoDBLockClientOptions;
import momento.lock.client.MomentoLockClient;
import momento.lock.client.MomentoLockClientHeartbeatHandler;
import momento.lock.client.MomentoLockItem;
import momento.lock.client.NoopDynamoDbClient;
import momento.lock.client.model.MomentoClientException;
import momento.sdk.CacheClient;
import momento.sdk.auth.CredentialProvider;
import momento.sdk.config.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

public class MomentoDynamoDBLockClient
extends AmazonDynamoDBLockClient
implements Closeable {
    private static final Log logger = LogFactory.getLog(MomentoDynamoDBLockClient.class);
    private final String lockCacheName;
    private final CacheClient cacheClient;
    private static final long DEFAULT_BUFFER_MS = 1000L;
    private static final int TTL_GRACE_MILLIS = 200;
    private final long leaseDurationMillis;
    private final long heartbeatPeriodInMilliseconds;
    private final String owner;
    private final ConcurrentHashMap<String, Thread> sessionMonitors;
    private final LockStorage lockStorage;
    private final Function<String, ThreadFactory> namedThreadCreator;
    private ScheduledExecutorService heartbeatExecutor;
    private MomentoLockClientHeartbeatHandler heartbeatHandler;
    private final MomentoLockClient momentoLockClient;
    private final Boolean holdLockOnServiceUnavailable;
    private final ScheduledExecutorService executorService;

    public MomentoDynamoDBLockClient(MomentoDynamoDBLockClientOptions lockClientOptions) {
        super(AmazonDynamoDBLockClientOptions.builder((DynamoDbClient)new NoopDynamoDbClient(), (String)lockClientOptions.getCacheName()).build());
        Objects.requireNonNull(lockClientOptions.getTableName(), "Table name cannot be null");
        Objects.requireNonNull(lockClientOptions.getCacheName(), "Cache name cannot be null");
        Objects.requireNonNull(lockClientOptions.getOwnerName(), "Owner name cannot be null");
        Objects.requireNonNull(lockClientOptions.getTimeUnit(), "Time unit cannot be null");
        Objects.requireNonNull(lockClientOptions.getPartitionKeyName(), "Partition Key Name cannot be null");
        Objects.requireNonNull(lockClientOptions.getSortKeyName(), "Sort Key Name cannot be null (use Optional.absent())");
        Objects.requireNonNull(lockClientOptions.getNamedThreadCreator(), "Named thread creator cannot be null");
        this.lockCacheName = lockClientOptions.getCacheName();
        this.sessionMonitors = new ConcurrentHashMap();
        this.owner = lockClientOptions.getOwnerName();
        this.leaseDurationMillis = lockClientOptions.getTimeUnit().toMillis(lockClientOptions.getLeaseDuration());
        this.heartbeatPeriodInMilliseconds = lockClientOptions.getTimeUnit().toMillis(lockClientOptions.getHeartbeatPeriod());
        this.namedThreadCreator = lockClientOptions.getNamedThreadCreator();
        this.holdLockOnServiceUnavailable = lockClientOptions.getHoldLockOnServiceUnavailable();
        this.cacheClient = CacheClient.create((CredentialProvider)lockClientOptions.getCredentialProvider(), (Configuration)lockClientOptions.getConfiguration(), (Duration)Duration.ofMillis(this.leaseDurationMillis));
        this.momentoLockClient = new MomentoLockClient(this.cacheClient, this.lockCacheName);
        this.lockStorage = new LockStorage();
        this.heartbeatHandler = new MomentoLockClientHeartbeatHandler(this.lockStorage, this.cacheClient, this.lockCacheName, Duration.ofMillis(this.leaseDurationMillis), this.holdLockOnServiceUnavailable, lockClientOptions.getTotalNumBackgroundThreadsForHeartbeating());
        if (lockClientOptions.getCreateHeartbeatBackgroundThread().booleanValue()) {
            if (this.leaseDurationMillis < 2L * this.heartbeatPeriodInMilliseconds) {
                throw new IllegalArgumentException("Heartbeat period must be no more than half the length of the Lease Duration, or locks might expire due to the heartbeat thread taking too long to update them (recommendation is to make it much greater, for example 4+ times greater)");
            }
            this.heartbeatExecutor = new ScheduledThreadPoolExecutor(1);
            this.heartbeatExecutor.scheduleAtFixedRate(this.heartbeatHandler, 0L, this.heartbeatPeriodInMilliseconds, TimeUnit.MILLISECONDS);
        }
        this.executorService = new ScheduledThreadPoolExecutor(lockClientOptions.getTotalNumThreadsForAcquiringLocks());
    }

    public Stream<LockItem> getAllLocksFromDynamoDB(boolean deleteOnRelease) {
        throw new UnsupportedOperationException("This operation is not available on Momento DynamoDB lock client");
    }

    public Stream<LockItem> getLocksByPartitionKey(String key, boolean deleteOnRelease) {
        throw new UnsupportedOperationException("This operation is not available on Momento DynamoDB lock client");
    }

    public void createLockCache(String cacheName) {
        try {
            this.momentoLockClient.createLockCache(cacheName);
        }
        catch (MomentoClientException e) {
            throw SdkClientException.create((String)e.getMessage(), (Throwable)e.getCause());
        }
    }

    public LockItem acquireLock(AcquireLockOptions options) throws LockNotGrantedException, InterruptedException {
        try {
            Optional sessionMonitor;
            Optional<MomentoLockItem> lockFromMomento;
            Optional<LockItem> localLock;
            String partitionKey = options.getPartitionKey();
            Optional sortKey = options.getSortKey();
            String cacheKey = MomentoDynamoDBLockClient.generateCacheKey(partitionKey, sortKey);
            if (options.getReentrant().booleanValue() && (localLock = this.lockStorage.getLock(cacheKey)).isPresent() && (lockFromMomento = this.momentoLockClient.getLockFromMomento(cacheKey)).isPresent() && lockFromMomento.get().getOwner().equals(this.owner)) {
                return localLock.get();
            }
            MomentoDynamoDBLockClient.validateAttributes(options, partitionKey, sortKey);
            long millisecondsToWait = 1000L;
            if (options.getAdditionalTimeToWaitForLock() != null) {
                Objects.requireNonNull(options.getTimeUnit(), "timeUnit must not be null if additionalTimeToWaitForLock is non-null");
                millisecondsToWait = options.getTimeUnit().toMillis(options.getAdditionalTimeToWaitForLock());
            }
            millisecondsToWait += this.leaseDurationMillis;
            long refreshPeriodInMilliseconds = 1000L;
            if (options.getRefreshPeriod() != null) {
                Objects.requireNonNull(options.getTimeUnit(), "timeUnit must not be null if refreshPeriod is non-null");
                refreshPeriodInMilliseconds = options.getTimeUnit().toMillis(options.getRefreshPeriod());
            }
            if ((sessionMonitor = options.getSessionMonitor()).isPresent()) {
                MomentoDynamoDBLockClient.sessionMonitorArgsValidate(((SessionMonitor)sessionMonitor.get()).getSafeTimeMillis(), this.heartbeatPeriodInMilliseconds, this.leaseDurationMillis);
            }
            return this.acquireLockWithRetries(options, cacheKey, millisecondsToWait, refreshPeriodInMilliseconds);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof LockCurrentlyUnavailableException) {
                throw new LockCurrentlyUnavailableException(e.getMessage());
            }
            if (t instanceof LockNotGrantedException) {
                throw new LockNotGrantedException(e.getMessage());
            }
            throw SdkClientException.create((String)t.getMessage(), (Throwable)t.getCause());
        }
        catch (InterruptedException e) {
            throw SdkClientException.create((String)e.getMessage(), (Throwable)e.getCause());
        }
    }

    private static String generateCacheKey(String partitionKey, Optional<String> sortKey) {
        String cacheKey = partitionKey;
        if (sortKey.isPresent()) {
            cacheKey = cacheKey + "_" + sortKey.get();
        }
        return cacheKey;
    }

    private LockItem acquireLockWithRetries(AcquireLockOptions options, String cacheKey, long totalWaitTime, long waitTimeIfLockAcquired) throws InterruptedException, ExecutionException {
        ScheduledFuture<LockItem> future;
        LockItem item;
        long startTimeMillis = LockClientUtils.INSTANCE.millisecondTime();
        LockItem lockItem = new LockItem((AmazonDynamoDBLockClient)this, options.getPartitionKey(), options.getSortKey(), options.getData(), options.getDeleteLockOnRelease().booleanValue(), this.owner, this.leaseDurationMillis, startTimeMillis, cacheKey, false, options.getSessionMonitor(), options.getAdditionalAttributes());
        long delay = 0L;
        while ((item = (LockItem)(future = this.executorService.schedule(() -> {
            logger.trace((Object)("Call Momento Get to see if the lock for key = " + cacheKey + "exists in the cache"));
            Optional<MomentoLockItem> lockFromMomento = this.momentoLockClient.getLockFromMomento(cacheKey);
            if (!lockFromMomento.isPresent() && options.getAcquireOnlyIfLockAlreadyExists().booleanValue()) {
                throw new LockNotGrantedException("Lock does not exist.");
            }
            if (lockFromMomento.isPresent() && options.shouldSkipBlockingWait()) {
                throw new LockCurrentlyUnavailableException("The lock being requested is being held by another client.");
            }
            boolean acquired = this.momentoLockClient.acquireLockInMomento(LockItemUtils.toMomentoLockItem(lockItem));
            if (acquired) {
                return lockItem;
            }
            if (LockClientUtils.INSTANCE.millisecondTime() - startTimeMillis > totalWaitTime) {
                throw new LockNotGrantedException("Didn't acquire lock after sleeping for " + (LockClientUtils.INSTANCE.millisecondTime() - startTimeMillis) + " milliseconds");
            }
            logger.debug((Object)("Someone else has the lock for key " + cacheKey + " .I will block until the  lease duration plus the configured timeout through additionalTimeToWaitForLock"));
            return null;
        }, delay, TimeUnit.MILLISECONDS)).get()) == null) {
            if (delay != 0L) continue;
            delay = waitTimeIfLockAcquired;
        }
        this.lockStorage.addLock(cacheKey, item);
        this.tryAddSessionMonitor(cacheKey, item);
        return item;
    }

    private static void validateAttributes(AcquireLockOptions options, String partitionKey, Optional<String> sortKey) {
        if (options.getAdditionalAttributes().containsKey(partitionKey) || options.getAdditionalAttributes().containsKey("ownerName") || options.getAdditionalAttributes().containsKey("leaseDuration") || options.getAdditionalAttributes().containsKey("recordVersionNumber") || options.getAdditionalAttributes().containsKey("data") || sortKey.isPresent() && options.getAdditionalAttributes().containsKey(sortKey.get())) {
            throw new IllegalArgumentException(String.format("Additional attribute cannot be one of the following types: %s, %s, %s, %s, %s", partitionKey, "ownerName", "leaseDuration", "recordVersionNumber", "data"));
        }
    }

    public boolean hasLock(String key, Optional<String> sortKey) {
        String cacheKey = MomentoDynamoDBLockClient.generateCacheKey(key, sortKey);
        return this.lockStorage.hasLock(cacheKey);
    }

    public boolean lockTableExists() {
        return this.lockCacheExists();
    }

    public boolean lockCacheExists() {
        try {
            return this.momentoLockClient.lockCacheExists(this.tableName);
        }
        catch (MomentoClientException e) {
            throw SdkClientException.create((String)e.getMessage(), (Throwable)e.getCause());
        }
    }

    public Optional<LockItem> tryAcquireLock(AcquireLockOptions options) throws InterruptedException {
        try {
            return Optional.of(this.acquireLock(options));
        }
        catch (LockNotGrantedException x) {
            return Optional.empty();
        }
    }

    private void tryAddSessionMonitor(String lockName, LockItem lock) {
        if (lock.hasSessionMonitor() && lock.hasCallback()) {
            Thread monitorThread = this.lockSessionMonitorChecker(lockName, lock);
            monitorThread.setDaemon(true);
            monitorThread.start();
            this.sessionMonitors.put(lockName, monitorThread);
        }
    }

    private Thread lockSessionMonitorChecker(String monitorName, LockItem lock) {
        return this.namedThreadCreator.apply(monitorName + "-sessionMonitor").newThread(() -> {
            try {
                long millisUntilDangerZone;
                while ((millisUntilDangerZone = lock.millisecondsUntilDangerZoneEntered()) > 0L) {
                    Thread.sleep(millisUntilDangerZone);
                }
                lock.runSessionMonitor();
                this.sessionMonitors.remove(monitorName);
                return;
            }
            catch (InterruptedException e) {
                return;
            }
        });
    }

    public Optional<LockItem> getLock(String key, Optional<String> sortKey) {
        String cacheKey = MomentoDynamoDBLockClient.generateCacheKey(key, sortKey);
        Optional<LockItem> lockItem = this.lockStorage.getLock(cacheKey);
        if (lockItem.isPresent()) {
            return lockItem;
        }
        Optional<MomentoLockItem> momentoLockItem = this.momentoLockClient.getLockFromMomento(cacheKey);
        if (momentoLockItem.isPresent()) {
            MomentoLockItem item = momentoLockItem.get();
            return Optional.of(new LockItem((AmazonDynamoDBLockClient)this, item.getPartitionKey(), Optional.ofNullable(item.getSortKey()), Optional.ofNullable(item.getData()), item.getDeleteLockOnRelease(), item.getOwner(), item.getLeaseDuration(), LockClientUtils.INSTANCE.millisecondTime(), item.getPartitionKey(), item.isReleased(), Optional.empty(), item.getAdditionalData()));
        }
        return Optional.empty();
    }

    public boolean releaseLock(LockItem item) {
        Objects.requireNonNull(item, "LockItem cannot be null");
        return this.releaseLock(ReleaseLockOptions.builder((LockItem)item).withDeleteLock(item.getDeleteLockItemOnClose()).build());
    }

    public boolean releaseLock(ReleaseLockOptions options) {
        boolean deleted;
        block4: {
            Objects.requireNonNull(options, "ReleaseLockOptions cannot be null");
            LockItem lockItem = options.getLockItem();
            String partitionKey = lockItem.getPartitionKey();
            Optional sortKey = lockItem.getSortKey();
            String cacheKey = MomentoDynamoDBLockClient.generateCacheKey(partitionKey, sortKey);
            deleted = this.lockStorage.removeLock(cacheKey);
            if (deleted && lockItem.getDeleteLockItemOnClose()) {
                MomentoLockItem momentoLockItem = LockItemUtils.toMomentoLockItem(lockItem);
                try {
                    Optional<MomentoLockItem> item;
                    long remainingTtl = this.momentoLockClient.getLockRemainingTtl(momentoLockItem);
                    if (remainingTtl > 200L && (item = this.momentoLockClient.getLockFromMomento(momentoLockItem.getCacheKey())).isPresent() && item.get().getOwner().equals(this.owner)) {
                        deleted = this.momentoLockClient.deleteLockFromMomento(LockItemUtils.toMomentoLockItem(lockItem));
                    }
                }
                catch (MomentoClientException e) {
                    if (options.isBestEffort()) break block4;
                    throw SdkClientException.create((String)e.getMessage(), (Throwable)e.getCause());
                }
            }
        }
        return deleted;
    }

    private void releaseAllLocks() {
        this.lockStorage.getAllLocks().forEach(l -> this.releaseLock(ReleaseLockOptions.builder((LockItem)l).withBestEffort(true).build()));
    }

    public void sendHeartbeat(LockItem lockItem) {
        this.heartbeatHandler.heartBeat(lockItem, LockItemUtils.toMomentoLockItem(lockItem));
    }

    public void sendHeartbeat(SendHeartbeatOptions options) {
        Objects.requireNonNull(options, "options is required");
        Objects.requireNonNull(options.getLockItem(), "Cannot send heartbeat for null lock");
        this.sendHeartbeat(options.getLockItem());
    }

    @Override
    public void close() throws IOException {
        this.releaseAllLocks();
        this.heartbeatExecutor.shutdown();
        this.executorService.shutdown();
        this.cacheClient.close();
    }

    private static void sessionMonitorArgsValidate(long safeTimeWithoutHeartbeatMillis, long heartbeatPeriodMillis, long leaseDurationMillis) throws IllegalArgumentException {
        if (safeTimeWithoutHeartbeatMillis <= heartbeatPeriodMillis) {
            throw new IllegalArgumentException("safeTimeWithoutHeartbeat must be greater than heartbeat frequency");
        }
        if (safeTimeWithoutHeartbeatMillis >= leaseDurationMillis) {
            throw new IllegalArgumentException("safeTimeWithoutHeartbeat must be less than the lock's lease duration");
        }
    }
}

