/*
 * Decompiled with CFR 0.152.
 */
package software.hoegg.mule.tasks;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.mule.tools.maven.plugin.app.ArtifactFilter;
import org.mule.tools.maven.plugin.app.Exclusion;
import org.mule.tools.maven.plugin.app.Inclusion;

public class BundleLibsTask {
    public void bundleLibDependencies(MavenProject project, List<Inclusion> inclusions, List<Exclusion> exclusions, File outputDirectory) throws MojoFailureException {
        File libDir = new File(outputDirectory, "lib");
        if (!libDir.exists()) {
            libDir.mkdirs();
        }
        for (Artifact a : this.getLibDependencies(project, inclusions, exclusions)) {
            try {
                FileUtils.copyFileToDirectory((File)a.getFile(), (File)libDir);
            }
            catch (IOException e) {
                throw new MojoFailureException("Unable to copy dependency to bundle lib", (Throwable)e);
            }
        }
    }

    private Set<Artifact> getLibDependencies(MavenProject project, List<Inclusion> inclusions, List<Exclusion> exclusions) {
        ArtifactFilter filter = new ArtifactFilter(project, inclusions, exclusions, true);
        return this.keepOnlyJarArtifacts(filter.getArtifactsToArchive());
    }

    private Set<Artifact> keepOnlyJarArtifacts(Set<Artifact> artifactsToArchive) {
        return (Set)CollectionUtils.select(artifactsToArchive, (Predicate)new Predicate<Artifact>(){

            public boolean evaluate(Artifact a) {
                return "jar".equals(a.getType());
            }
        }, new HashSet());
    }
}

